/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaMetadataRetriever;
import com.hw.videoprocessor.VideoProcessor;
import com.hw.videoprocessor.VideoUtil;
import com.hw.videoprocessor.util.CL;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class VideoEffects {
    public static void doKichiku(Context context, String inputVideo, String outputVideo, float speed, int splitTimeMs) throws IOException {
        List<File> fileList;
        long s = System.currentTimeMillis();
        File cacheDir = new File(context.getCacheDir(), "kichiku_" + System.currentTimeMillis());
        cacheDir.mkdir();
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(inputVideo);
        int oriBitrate = Integer.parseInt(retriever.extractMetadata(20));
        retriever.release();
        CL.w("\u52a0\u901f\u89c6\u9891+", new Object[0]);
        File speedVideo = new File(cacheDir, "speed_" + speed + ".tmp");
        VideoProcessor.processVideo(context, inputVideo, speedVideo.getAbsolutePath(), null, null, null, null, Float.valueOf(speed), null, null);
        CL.w("\u52a0\u901f\u89c6\u9891-", new Object[0]);
        int bitrate = VideoUtil.getBitrateForAllKeyFrameVideo(inputVideo);
        try {
            CL.w("\u5207\u5272\u89c6\u9891+", new Object[0]);
            fileList = VideoUtil.splitVideo(context, speedVideo.getAbsolutePath(), cacheDir.getAbsolutePath(), splitTimeMs, 500, bitrate, 0);
        }
        catch (MediaCodec.CodecException e) {
            CL.e(e);
            fileList = VideoUtil.splitVideo(context, speedVideo.getAbsolutePath(), cacheDir.getAbsolutePath(), splitTimeMs, 500, bitrate, -1);
        }
        CL.w("\u5207\u5272\u89c6\u9891-", new Object[0]);
        File cacheCombineFile = new File(cacheDir, "combine_" + System.currentTimeMillis() + ".tmp");
        CL.w("\u5408\u5e76\u89c6\u9891+", new Object[0]);
        VideoUtil.combineVideos(fileList, cacheCombineFile.getAbsolutePath());
        CL.w("\u5408\u5e76\u89c6\u9891-", new Object[0]);
        CL.w("\u89c6\u9891\u8f6c\u7801+", new Object[0]);
        VideoProcessor.processVideo(context, cacheCombineFile.getAbsolutePath(), outputVideo, null, null, null, null, null, oriBitrate, 1);
        cacheCombineFile.delete();
        CL.w("\u89c6\u9891\u8f6c\u7801-", new Object[0]);
        long e = System.currentTimeMillis();
        CL.e("\u9b3c\u755c\u5df2\u5b8c\u6210,\u8017\u65f6:" + (float)(e - s) / 1000.0f + "s", new Object[0]);
    }
}

