/*
 * Decompiled with CFR 0.152.
 */
package com.hw.videoprocessor.util;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.support.annotation.IntRange;
import com.hw.videoprocessor.VideoUtil;
import com.hw.videoprocessor.util.CL;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class AudioUtil {
    static final String TAG = "VideoProcessor";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustPcmVolumn(String fromPath, String toPath, @IntRange(from=0L, to=100L) int volumn) throws IOException {
        float vol = AudioUtil.normalizeVolumn(volumn);
        byte[] buffer = new byte[2048];
        FileInputStream fileInputStream = new FileInputStream(fromPath);
        FileOutputStream fileOutputStream = new FileOutputStream(toPath);
        try {
            while (fileInputStream.read(buffer) != -1) {
                for (int i = 0; i < buffer.length; i += 2) {
                    int tmp = buffer[i] & 0xFF | (buffer[i + 1] & 0xFF) << 8;
                    if ((tmp = (int)((float)tmp * vol)) > Short.MAX_VALUE) {
                        tmp = Short.MAX_VALUE;
                    } else if (tmp < Short.MIN_VALUE) {
                        tmp = Short.MIN_VALUE;
                    }
                    buffer[i] = (byte)(tmp & 0xFF);
                    buffer[i + 1] = (byte)(tmp >>> 8 & 0xFF);
                }
                fileOutputStream.write(buffer);
            }
        }
        finally {
            fileInputStream.close();
            fileOutputStream.close();
        }
    }

    private static float normalizeVolumn(@IntRange(from=0L, to=100L) int volumn) {
        if (volumn <= 50) {
            return (float)volumn / 50.0f;
        }
        return (float)(volumn - 50) / 50.0f * 39.0f + 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mixPcm(String pcm1Path, String pcm2Path, String toPath, @IntRange(from=0L, to=100L) int volumn1, @IntRange(from=0L, to=100L) int volumn2) throws IOException {
        float vol1 = AudioUtil.normalizeVolumn(volumn1);
        float vol2 = AudioUtil.normalizeVolumn(volumn2);
        byte[] buffer1 = new byte[2048];
        byte[] buffer2 = new byte[2048];
        byte[] buffer3 = new byte[2048];
        FileInputStream is1 = new FileInputStream(pcm1Path);
        FileInputStream is2 = new FileInputStream(pcm2Path);
        FileOutputStream fileOutputStream = new FileOutputStream(toPath);
        boolean end1 = false;
        boolean end2 = false;
        try {
            while (!end1 || !end2) {
                if (!end1) {
                    end1 = is1.read(buffer1) == -1;
                    System.arraycopy(buffer1, 0, buffer3, 0, buffer1.length);
                }
                if (!end2) {
                    end2 = is2.read(buffer2) == -1;
                    for (int i = 0; i < buffer2.length; i += 2) {
                        short temp2 = (short)(buffer2[i] & 0xFF | (buffer2[i + 1] & 0xFF) << 8);
                        short temp1 = (short)(buffer1[i] & 0xFF | (buffer1[i + 1] & 0xFF) << 8);
                        int temp = (int)((float)temp2 * vol2 + (float)temp1 * vol1);
                        if (temp > Short.MAX_VALUE) {
                            temp = Short.MAX_VALUE;
                        } else if (temp < Short.MIN_VALUE) {
                            temp = Short.MIN_VALUE;
                        }
                        buffer3[i] = (byte)(temp & 0xFF);
                        buffer3[i + 1] = (byte)(temp >>> 8 & 0xFF);
                    }
                }
                fileOutputStream.write(buffer3);
            }
        }
        finally {
            is1.close();
            is2.close();
            fileOutputStream.close();
        }
    }

    public static void stereoToMono(String from, String to) throws IOException {
        FileInputStream is = new FileInputStream(from);
        FileOutputStream os = new FileOutputStream(to);
        byte[] buffer1 = new byte[2048];
        byte[] buffer2 = new byte[1024];
        while (is.read(buffer1) != -1) {
            for (int i = 0; i < buffer2.length; i += 2) {
                buffer2[i] = buffer1[2 * i];
                buffer2[i + 1] = buffer1[2 * i + 1];
            }
            os.write(buffer2);
        }
        is.close();
        os.close();
    }

    public static void copyFile(String from, String to) throws IOException {
        FileChannel toChannel = new FileOutputStream(to).getChannel();
        FileChannel fromChannel = new FileInputStream(from).getChannel();
        fromChannel.transferTo(0L, fromChannel.size(), toChannel);
    }

    public static boolean isStereo(String aacPath) throws IOException {
        String mime;
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(aacPath);
        MediaFormat format = null;
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks && !(mime = (format = extractor.getTrackFormat(i)).getString("mime")).startsWith("audio/"); ++i) {
        }
        extractor.release();
        if (format == null) {
            return false;
        }
        return format.getInteger("channel-count") > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File checkAndFillPcm(File aacPcmFile, int pcmDuration, int fileToDuration) {
        if (pcmDuration >= fileToDuration) {
            return aacPcmFile;
        }
        File cacheFile = new File(aacPcmFile.getAbsolutePath() + ".concat");
        FileInputStream is = null;
        FileOutputStream os = null;
        AbstractInterruptibleChannel from = null;
        AbstractInterruptibleChannel to = null;
        try {
            float repeat = (float)fileToDuration / (float)pcmDuration;
            int repeatInt = (int)repeat;
            is = new FileInputStream(aacPcmFile);
            os = new FileOutputStream(cacheFile);
            from = is.getChannel();
            to = os.getChannel();
            for (int i = 0; i < repeatInt; ++i) {
                ((FileChannel)from).transferTo(0L, ((FileChannel)from).size(), (WritableByteChannel)((Object)to));
                ((FileChannel)from).position(0L);
            }
            float remain = repeat - (float)repeatInt;
            int remainSize = (int)((float)aacPcmFile.length() * remain);
            if (remainSize > 1024) {
                ((FileChannel)from).transferTo(0L, remainSize, (WritableByteChannel)((Object)to));
            }
            from.close();
            to.close();
            aacPcmFile.delete();
            cacheFile.renameTo(aacPcmFile);
            File file = aacPcmFile;
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            cacheFile.delete();
            File file = aacPcmFile;
            return file;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                if (from != null) {
                    from.close();
                }
                if (to != null) {
                    to.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeToPCM(String audioPath, String outPath, Integer startTimeUs, Integer endTimeUs) throws IOException {
        MediaExtractor extractor = new MediaExtractor();
        extractor.setDataSource(audioPath);
        int audioTrack = VideoUtil.selectTrack(extractor, true);
        extractor.selectTrack(audioTrack);
        if (startTimeUs == null) {
            startTimeUs = 0;
        }
        extractor.seekTo((long)startTimeUs.intValue(), 2);
        MediaFormat oriAudioFormat = extractor.getTrackFormat(audioTrack);
        int maxBufferSize = oriAudioFormat.containsKey("max-input-size") ? oriAudioFormat.getInteger("max-input-size") : 100000;
        ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        MediaCodec decoder = MediaCodec.createDecoderByType((String)oriAudioFormat.getString("mime"));
        decoder.configure(oriAudioFormat, null, null, 0);
        decoder.start();
        boolean decodeDone = false;
        boolean decodeInputDone = false;
        int TIMEOUT_US = 2500;
        File pcmFile = new File(outPath);
        FileChannel writeChannel = new FileOutputStream(pcmFile).getChannel();
        try {
            while (!decodeDone) {
                int outputBufferIndex;
                if (!decodeInputDone) {
                    boolean eof = false;
                    int decodeInputIndex = decoder.dequeueInputBuffer(2500L);
                    if (decodeInputIndex >= 0) {
                        long sampleTimeUs = extractor.getSampleTime();
                        if (sampleTimeUs == -1L) {
                            eof = true;
                        } else {
                            if (sampleTimeUs < (long)startTimeUs.intValue()) {
                                extractor.advance();
                                continue;
                            }
                            if (endTimeUs != null && sampleTimeUs > (long)endTimeUs.intValue()) {
                                eof = true;
                            }
                        }
                        if (eof) {
                            decodeInputDone = true;
                            decoder.queueInputBuffer(decodeInputIndex, 0, 0, 0L, 4);
                        } else {
                            info.size = extractor.readSampleData(buffer, 0);
                            info.presentationTimeUs = sampleTimeUs;
                            info.flags = extractor.getSampleFlags();
                            ByteBuffer inputBuffer = decoder.getInputBuffer(decodeInputIndex);
                            inputBuffer.put(buffer);
                            CL.it(TAG, "audio decode queueInputBuffer " + info.presentationTimeUs / 1000L, new Object[0]);
                            decoder.queueInputBuffer(decodeInputIndex, 0, info.size, info.presentationTimeUs, info.flags);
                            extractor.advance();
                        }
                    }
                }
                while (!decodeDone && (outputBufferIndex = decoder.dequeueOutputBuffer(info, 2500L)) != -1) {
                    if (outputBufferIndex == -2) {
                        MediaFormat newFormat = decoder.getOutputFormat();
                        CL.it(TAG, "audio decode newFormat = " + newFormat, new Object[0]);
                        continue;
                    }
                    if (outputBufferIndex < 0) {
                        CL.et(TAG, "unexpected result from audio decoder.dequeueOutputBuffer: " + outputBufferIndex, new Object[0]);
                        continue;
                    }
                    if (info.flags == 4) {
                        decodeDone = true;
                    } else {
                        ByteBuffer decodeOutputBuffer = decoder.getOutputBuffer(outputBufferIndex);
                        CL.it(TAG, "audio decode saveFrame " + info.presentationTimeUs / 1000L, new Object[0]);
                        writeChannel.write(decodeOutputBuffer);
                    }
                    decoder.releaseOutputBuffer(outputBufferIndex, false);
                }
            }
        }
        finally {
            writeChannel.close();
            extractor.release();
            decoder.stop();
            decoder.release();
        }
    }
}

