/*
 * Decompiled with CFR 0.152.
 */
package com.github.ybq.android.spinkit.style;

import android.animation.ValueAnimator;
import android.graphics.Rect;
import android.os.Build;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.github.ybq.android.spinkit.animation.SpriteAnimatorBuilder;
import com.github.ybq.android.spinkit.sprite.CircleSprite;
import com.github.ybq.android.spinkit.sprite.Sprite;
import com.github.ybq.android.spinkit.sprite.SpriteContainer;

public class ChasingDots
extends SpriteContainer {
    @Override
    public Sprite[] onCreateChild() {
        return new Sprite[]{new Dot(), new Dot()};
    }

    @Override
    public void onChildCreated(Sprite ... sprites) {
        super.onChildCreated(sprites);
        if (Build.VERSION.SDK_INT >= 24) {
            sprites[1].setAnimationDelay(1000);
        } else {
            sprites[1].setAnimationDelay(-1000);
        }
    }

    @Override
    public ValueAnimator onCreateAnimation() {
        float[] fractions = new float[]{0.0f, 1.0f};
        return new SpriteAnimatorBuilder(this).rotate(fractions, 0, 360).duration(2000L).interpolator((Interpolator)new LinearInterpolator()).build();
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        bounds = this.clipSquare(bounds);
        int drawW = (int)((float)bounds.width() * 0.6f);
        this.getChildAt(0).setDrawBounds(bounds.right - drawW, bounds.top, bounds.right, bounds.top + drawW);
        this.getChildAt(1).setDrawBounds(bounds.right - drawW, bounds.bottom - drawW, bounds.right, bounds.bottom);
    }

    private class Dot
    extends CircleSprite {
        Dot() {
            this.setScale(0.0f);
        }

        @Override
        public ValueAnimator onCreateAnimation() {
            float[] fractions = new float[]{0.0f, 0.5f, 1.0f};
            return new SpriteAnimatorBuilder(this).scale(fractions, Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f)).duration(2000L).easeInOut(fractions).build();
        }
    }
}

