/*
 * Decompiled with CFR 0.152.
 */
package com.github.ybq.android.spinkit.sprite;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.Property;
import com.github.ybq.android.spinkit.animation.AnimationUtils;
import com.github.ybq.android.spinkit.animation.FloatProperty;
import com.github.ybq.android.spinkit.animation.IntProperty;

public abstract class Sprite
extends Drawable
implements ValueAnimator.AnimatorUpdateListener,
Animatable,
Drawable.Callback {
    private float scale = 1.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float pivotX;
    private float pivotY;
    private int animationDelay;
    private int rotateX;
    private int rotateY;
    private int translateX;
    private int translateY;
    private int rotate;
    private float translateXPercentage;
    private float translateYPercentage;
    private ValueAnimator animator;
    private int alpha = 255;
    private static final Rect ZERO_BOUNDS_RECT = new Rect();
    protected Rect drawBounds = ZERO_BOUNDS_RECT;
    private Camera mCamera = new Camera();
    private Matrix mMatrix = new Matrix();
    public static final Property<Sprite, Integer> ROTATE_X = new IntProperty<Sprite>("rotateX"){

        @Override
        public void setValue(Sprite object, int value) {
            object.setRotateX(value);
        }

        public Integer get(Sprite object) {
            return object.getRotateX();
        }
    };
    public static final Property<Sprite, Integer> ROTATE = new IntProperty<Sprite>("rotate"){

        @Override
        public void setValue(Sprite object, int value) {
            object.setRotate(value);
        }

        public Integer get(Sprite object) {
            return object.getRotate();
        }
    };
    public static final Property<Sprite, Integer> ROTATE_Y = new IntProperty<Sprite>("rotateY"){

        @Override
        public void setValue(Sprite object, int value) {
            object.setRotateY(value);
        }

        public Integer get(Sprite object) {
            return object.getRotateY();
        }
    };
    public static final Property<Sprite, Integer> TRANSLATE_X = new IntProperty<Sprite>("translateX"){

        @Override
        public void setValue(Sprite object, int value) {
            object.setTranslateX(value);
        }

        public Integer get(Sprite object) {
            return object.getTranslateX();
        }
    };
    public static final Property<Sprite, Integer> TRANSLATE_Y = new IntProperty<Sprite>("translateY"){

        @Override
        public void setValue(Sprite object, int value) {
            object.setTranslateY(value);
        }

        public Integer get(Sprite object) {
            return object.getTranslateY();
        }
    };
    public static final Property<Sprite, Float> TRANSLATE_X_PERCENTAGE = new FloatProperty<Sprite>("translateXPercentage"){

        @Override
        public void setValue(Sprite object, float value) {
            object.setTranslateXPercentage(value);
        }

        public Float get(Sprite object) {
            return Float.valueOf(object.getTranslateXPercentage());
        }
    };
    public static final Property<Sprite, Float> TRANSLATE_Y_PERCENTAGE = new FloatProperty<Sprite>("translateYPercentage"){

        @Override
        public void setValue(Sprite object, float value) {
            object.setTranslateYPercentage(value);
        }

        public Float get(Sprite object) {
            return Float.valueOf(object.getTranslateYPercentage());
        }
    };
    public static final Property<Sprite, Float> SCALE_X = new FloatProperty<Sprite>("scaleX"){

        @Override
        public void setValue(Sprite object, float value) {
            object.setScaleX(value);
        }

        public Float get(Sprite object) {
            return Float.valueOf(object.getScaleX());
        }
    };
    public static final Property<Sprite, Float> SCALE_Y = new FloatProperty<Sprite>("scaleY"){

        @Override
        public void setValue(Sprite object, float value) {
            object.setScaleY(value);
        }

        public Float get(Sprite object) {
            return Float.valueOf(object.getScaleY());
        }
    };
    public static final Property<Sprite, Float> SCALE = new FloatProperty<Sprite>("scale"){

        @Override
        public void setValue(Sprite object, float value) {
            object.setScale(value);
        }

        public Float get(Sprite object) {
            return Float.valueOf(object.getScale());
        }
    };
    public static final Property<Sprite, Integer> ALPHA = new IntProperty<Sprite>("alpha"){

        @Override
        public void setValue(Sprite object, int value) {
            object.setAlpha(value);
        }

        public Integer get(Sprite object) {
            return object.getAlpha();
        }
    };

    public abstract int getColor();

    public abstract void setColor(int var1);

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getOpacity() {
        return 1;
    }

    public float getTranslateXPercentage() {
        return this.translateXPercentage;
    }

    public void setTranslateXPercentage(float translateXPercentage) {
        this.translateXPercentage = translateXPercentage;
    }

    public float getTranslateYPercentage() {
        return this.translateYPercentage;
    }

    public void setTranslateYPercentage(float translateYPercentage) {
        this.translateYPercentage = translateYPercentage;
    }

    public int getTranslateX() {
        return this.translateX;
    }

    public void setTranslateX(int translateX) {
        this.translateX = translateX;
    }

    public int getTranslateY() {
        return this.translateY;
    }

    public void setTranslateY(int translateY) {
        this.translateY = translateY;
    }

    public int getRotate() {
        return this.rotate;
    }

    public void setRotate(int rotate) {
        this.rotate = rotate;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.setScaleX(scale);
        this.setScaleY(scale);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public int getRotateX() {
        return this.rotateX;
    }

    public void setRotateX(int rotateX) {
        this.rotateX = rotateX;
    }

    public int getRotateY() {
        return this.rotateY;
    }

    public void setRotateY(int rotateY) {
        this.rotateY = rotateY;
    }

    public float getPivotX() {
        return this.pivotX;
    }

    public void setPivotX(float pivotX) {
        this.pivotX = pivotX;
    }

    public float getPivotY() {
        return this.pivotY;
    }

    public void setPivotY(float pivotY) {
        this.pivotY = pivotY;
    }

    public int getAnimationDelay() {
        return this.animationDelay;
    }

    public Sprite setAnimationDelay(int animationDelay) {
        this.animationDelay = animationDelay;
        return this;
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public abstract ValueAnimator onCreateAnimation();

    public void start() {
        if (AnimationUtils.isStarted(this.animator)) {
            return;
        }
        this.animator = this.obtainAnimation();
        if (this.animator == null) {
            return;
        }
        AnimationUtils.start((Animator)this.animator);
        this.invalidateSelf();
    }

    public ValueAnimator obtainAnimation() {
        if (this.animator == null) {
            this.animator = this.onCreateAnimation();
        }
        if (this.animator != null) {
            this.animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
            this.animator.setStartDelay((long)this.animationDelay);
        }
        return this.animator;
    }

    public void stop() {
        if (AnimationUtils.isStarted(this.animator)) {
            this.animator.removeAllUpdateListeners();
            this.animator.end();
            this.reset();
        }
    }

    protected abstract void drawSelf(Canvas var1);

    public void reset() {
        this.scale = 1.0f;
        this.rotateX = 0;
        this.rotateY = 0;
        this.translateX = 0;
        this.translateY = 0;
        this.rotate = 0;
        this.translateXPercentage = 0.0f;
        this.translateYPercentage = 0.0f;
    }

    public boolean isRunning() {
        return AnimationUtils.isRunning(this.animator);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.setDrawBounds(bounds);
    }

    public void setDrawBounds(Rect drawBounds) {
        this.setDrawBounds(drawBounds.left, drawBounds.top, drawBounds.right, drawBounds.bottom);
    }

    public void setDrawBounds(int left, int top, int right, int bottom) {
        this.drawBounds = new Rect(left, top, right, bottom);
        this.setPivotX(this.getDrawBounds().centerX());
        this.setPivotY(this.getDrawBounds().centerY());
    }

    public void invalidateDrawable(Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public Rect getDrawBounds() {
        return this.drawBounds;
    }

    public void draw(Canvas canvas) {
        int tx = this.getTranslateX();
        tx = tx == 0 ? (int)((float)this.getBounds().width() * this.getTranslateXPercentage()) : tx;
        int ty = this.getTranslateY();
        ty = ty == 0 ? (int)((float)this.getBounds().height() * this.getTranslateYPercentage()) : ty;
        canvas.translate((float)tx, (float)ty);
        canvas.scale(this.getScaleX(), this.getScaleY(), this.getPivotX(), this.getPivotY());
        canvas.rotate((float)this.getRotate(), this.getPivotX(), this.getPivotY());
        if (this.getRotateX() != 0 || this.getRotateY() != 0) {
            this.mCamera.save();
            this.mCamera.rotateX((float)this.getRotateX());
            this.mCamera.rotateY((float)this.getRotateY());
            this.mCamera.getMatrix(this.mMatrix);
            this.mMatrix.preTranslate(-this.getPivotX(), -this.getPivotY());
            this.mMatrix.postTranslate(this.getPivotX(), this.getPivotY());
            this.mCamera.restore();
            canvas.concat(this.mMatrix);
        }
        this.drawSelf(canvas);
    }

    public Rect clipSquare(Rect rect) {
        int w = rect.width();
        int h = rect.height();
        int min = Math.min(w, h);
        int cx = rect.centerX();
        int cy = rect.centerY();
        int r = min / 2;
        return new Rect(cx - r, cy - r, cx + r, cy + r);
    }
}

