/*
 * Decompiled with CFR 0.152.
 */
package com.github.ybq.android.spinkit.style;

import android.animation.ValueAnimator;
import android.graphics.Rect;
import com.github.ybq.android.spinkit.animation.SpriteAnimatorBuilder;
import com.github.ybq.android.spinkit.sprite.RectSprite;
import com.github.ybq.android.spinkit.sprite.Sprite;
import com.github.ybq.android.spinkit.sprite.SpriteGroup;

public class Wave
extends SpriteGroup {
    @Override
    public Sprite[] onCreateChild() {
        Sprite[] waveItems = new WaveItem[5];
        for (int i = 0; i < waveItems.length; ++i) {
            waveItems[i] = new WaveItem();
            waveItems[i].setAnimationDelay(-1200 + i * 100);
        }
        return waveItems;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        bounds = this.clipSquare(bounds);
        int rw = bounds.width() / this.getChildCount();
        int width = bounds.width() / 5 * 3 / 5;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Sprite sprite = this.getChildAt(i);
            int l = bounds.left + i * rw + rw / 5;
            int r = l + width;
            sprite.setDrawBounds(l, bounds.top, r, bounds.bottom);
        }
    }

    class WaveItem
    extends RectSprite {
        WaveItem() {
        }

        @Override
        public ValueAnimator getAnimation() {
            float[] fractions = new float[]{0.0f, 0.2f, 0.4f, 1.0f};
            return new SpriteAnimatorBuilder(this).scaleY(fractions, 0.4f, 1.0f, 0.4f, 0.4f).duration(1200L).easeInOut(fractions).build();
        }

        @Override
        public void onAnimationUpdate(ValueAnimator animation) {
            this.invalidateSelf();
        }
    }
}

