/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.util.concurrency;

import edu.uci.jforests.util.concurrency.BlockingThreadPoolExecutor;
import edu.uci.jforests.util.concurrency.TaskItem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskCollection<T extends TaskItem> {
    private List<T> tasks;

    public TaskCollection() {
        this.tasks = new ArrayList<T>();
    }

    public TaskCollection(Class<T> _c, int taskCount) {
        this.tasks = new ArrayList<T>(taskCount);
        try {
            for (int i = 0; i < taskCount; ++i) {
                TaskItem task = (TaskItem)_c.newInstance();
                this.tasks.add(task);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getSize() {
        return this.tasks.size();
    }

    public void addTask(T task) {
        this.tasks.add(task);
    }

    public T getTask(int idx) {
        return (T)((TaskItem)this.tasks.get(idx));
    }

    public void run() {
        for (TaskItem task : this.tasks) {
            BlockingThreadPoolExecutor.getInstance().execute(task);
        }
        BlockingThreadPoolExecutor.getInstance().await();
    }
}

