/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.util.concurrency;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BlockingThreadPoolExecutor
extends ThreadPoolExecutor {
    private Semaphore semaphore;
    private AtomicInteger tasksInProcess = new AtomicInteger();
    private final Lock lock = new ReentrantLock();
    private final Condition done = this.lock.newCondition();
    private static BlockingThreadPoolExecutor instance;

    public static synchronized void init(int poolSize) {
        if (instance != null) {
            return;
        }
        instance = new BlockingThreadPoolExecutor(poolSize);
    }

    public static BlockingThreadPoolExecutor getInstance() {
        return instance;
    }

    private BlockingThreadPoolExecutor(int poolSize) {
        super(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.semaphore = new Semaphore(poolSize);
    }

    public void execute(Runnable task) {
        boolean acquired = false;
        do {
            try {
                this.semaphore.acquire();
                acquired = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!acquired);
        this.tasksInProcess.incrementAndGet();
        try {
            super.execute(task);
        }
        catch (RuntimeException e) {
            this.tasksInProcess.decrementAndGet();
            this.semaphore.release();
            throw e;
        }
        catch (Error e) {
            this.tasksInProcess.decrementAndGet();
            this.semaphore.release();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        BlockingThreadPoolExecutor blockingThreadPoolExecutor = this;
        synchronized (blockingThreadPoolExecutor) {
            this.tasksInProcess.decrementAndGet();
            if (this.tasksInProcess.intValue() == 0) {
                this.lock.lock();
                try {
                    this.done.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        this.semaphore.release();
    }

    public void await() {
        try {
            this.lock.lock();
            try {
                while (this.tasksInProcess.get() > 0) {
                    this.done.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

