/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.util;

import edu.uci.jforests.util.Constants;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathUtil {
    public static double log2(double value) {
        return Math.log(value) / Constants.LN2;
    }

    public static double getAvg(double[] arr) {
        double sum = 0.0;
        for (double item : arr) {
            sum += item;
        }
        return sum / (double)arr.length;
    }

    public static double getAvg(float[] arr) {
        double sum = 0.0;
        float[] fArray = arr;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            double item = fArray[i];
            sum += item;
        }
        return sum / (double)arr.length;
    }

    public static double getAvg(List<Double> arr) {
        double sum = 0.0;
        for (double item : arr) {
            sum += item;
        }
        return sum / (double)arr.size();
    }

    public static double getStd(double[] arr) {
        return MathUtil.getStd(arr, MathUtil.getAvg(arr));
    }

    public static double getStd(List<Double> arr) {
        return MathUtil.getStd(arr, MathUtil.getAvg(arr));
    }

    public static double getStd(double[] arr, double avg) {
        return MathUtil.getStd(arr, avg, 0, arr.length);
    }

    public static double getStd(double[] arr, double avg, int offset, int count) {
        double sum = 0.0;
        int end = offset + count;
        for (int i = offset; i < end; ++i) {
            sum += Math.pow(arr[i] - avg, 2.0);
        }
        return Math.sqrt(sum / (double)count);
    }

    public static double getStd(List<Double> arr, double avg) {
        double sum = 0.0;
        for (double item : arr) {
            sum += Math.pow(item - avg, 2.0);
        }
        return Math.sqrt(sum / (double)arr.size());
    }

    public static double getVectorSize(double[] arr) {
        double sum = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            sum += arr[i] * arr[i];
        }
        return Math.sqrt(sum);
    }

    public static double getDotProduct(float[] vector1, float[] vector2, int length) {
        double product = 0.0;
        for (int i = 0; i < length; ++i) {
            product += (double)(vector1[i] * vector2[i]);
        }
        return product;
    }

    public static double getDotProduct(double[] vector1, double[] vector2, int length) {
        double product = 0.0;
        for (int i = 0; i < length; ++i) {
            product += vector1[i] * vector2[i];
        }
        return product;
    }

    public static double getDotProduct(float[] vector1, float[] vector2) {
        return MathUtil.getDotProduct(vector1, vector2, vector1.length);
    }

    public static void divideInPlace(float[] vector, float val) {
        int length = vector.length;
        int i = 0;
        while (i < length) {
            int n = i++;
            vector[n] = vector[n] / val;
        }
    }

    public static double[][] allocateDoubleMatrix(int m, int n) {
        double[][] mat = new double[m][];
        for (int i = 0; i < m; ++i) {
            mat[i] = new double[n];
        }
        return mat;
    }

    public static void clearDoubleMatrix(double[][] mat) {
        int rows = mat.length;
        for (int r = 0; r < rows; ++r) {
            int cols = mat[r].length;
            for (int c = 0; c < cols; ++c) {
                mat[r][c] = 0.0;
            }
        }
    }

    public static double[][] cloneDoubleMatrix(double[][] src) {
        int rows = src.length;
        double[][] clone = new double[rows][];
        for (int r = 0; r < rows; ++r) {
            int cols = src[r].length;
            clone[r] = new double[cols];
            for (int c = 0; c < cols; ++c) {
                clone[r][c] = src[r][c];
            }
        }
        return clone;
    }
}

