/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.util;

import edu.uci.jforests.config.ComponentConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigHolder {
    private Properties properties;
    private Map<String, ComponentConfig> configs;

    public ConfigHolder(Properties properties) {
        this.properties = properties;
        this.configs = new HashMap<String, ComponentConfig>();
    }

    public <T extends ComponentConfig> T getConfig(Class<T> _c) throws Exception {
        ComponentConfig config = this.configs.get(_c.getCanonicalName());
        if (config == null) {
            ComponentConfig newConfig = (ComponentConfig)_c.newInstance();
            newConfig.init(this);
            this.configs.put(_c.getCanonicalName(), newConfig);
            return (T)newConfig;
        }
        return (T)config;
    }

    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    public String getStringProperty(String key) {
        return this.properties.getProperty(key);
    }

    public int getIntProperty(String key) {
        return Integer.parseInt(this.properties.getProperty(key));
    }

    public double getDoubleProperty(String key) {
        return Double.parseDouble(this.properties.getProperty(key));
    }

    public boolean getBooleanProperty(String key) {
        return this.properties.getProperty(key).toLowerCase().trim().equals("true");
    }

    public Set<Map.Entry<Object, Object>> getEntries() {
        return this.properties.entrySet();
    }
}

