/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees.regression;

import edu.uci.jforests.dataset.Feature;
import edu.uci.jforests.dataset.Histogram;
import edu.uci.jforests.learning.trees.CandidateSplitsForLeaf;
import edu.uci.jforests.learning.trees.regression.RegressionCandidateSplitsForLeaf;
import java.util.Arrays;

public class RegressionHistogram
extends Histogram {
    public double sumTargets = 0.0;
    public double[] perValueSumTargets = new double[this.numValues];

    public RegressionHistogram(Feature feature) {
        super(feature);
    }

    protected void initCustomData(CandidateSplitsForLeaf leafSplitCandidates, int[] instances) {
        RegressionCandidateSplitsForLeaf rLeafSplitCandidates = (RegressionCandidateSplitsForLeaf)leafSplitCandidates;
        this.sumTargets = rLeafSplitCandidates.getSumTargets();
        Arrays.fill(this.perValueSumTargets, 0.0);
        this.feature.bins.initHistogram(this, this.totalCount, leafSplitCandidates.getTargets(), leafSplitCandidates.getWeights(), leafSplitCandidates.getIndices(), instances);
    }

    protected void subtractCustomData(Histogram child) {
        RegressionHistogram rChild = (RegressionHistogram)child;
        this.sumTargets -= rChild.sumTargets;
        for (int i = 0; i < this.numValues; ++i) {
            int n = i;
            this.perValueSumTargets[n] = this.perValueSumTargets[n] - rChild.perValueSumTargets[i];
        }
    }
}

