/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.trees.decision;

import edu.uci.jforests.dataset.Dataset;
import edu.uci.jforests.dataset.Feature;
import edu.uci.jforests.dataset.Histogram;
import edu.uci.jforests.learning.trees.CandidateSplitsForLeaf;
import edu.uci.jforests.learning.trees.Tree;
import edu.uci.jforests.learning.trees.TreeLearner;
import edu.uci.jforests.learning.trees.TreeSplit;
import edu.uci.jforests.learning.trees.decision.DecisionCandidateSplitsForLeaf;
import edu.uci.jforests.learning.trees.decision.DecisionHistogram;
import edu.uci.jforests.learning.trees.decision.DecisionTree;
import edu.uci.jforests.learning.trees.decision.DecisionTreeSplit;
import edu.uci.jforests.learning.trees.decision.Entropy;
import edu.uci.jforests.util.ConfigHolder;
import java.util.Arrays;

public class DecisionTreeLearner
extends TreeLearner {
    protected int numClasses;

    public DecisionTreeLearner() {
        super("DecisionTree");
    }

    public void init(int numClasses, Dataset dataset, ConfigHolder configHolder, int maxTrainInstances) throws Exception {
        this.numClasses = numClasses;
        super.init(dataset, configHolder, maxTrainInstances);
    }

    protected Tree getNewTree() {
        DecisionTree tree = new DecisionTree();
        tree.init(this.maxLeaves, this.numClasses);
        return tree;
    }

    protected TreeSplit getNewSplit() {
        return new DecisionTreeSplit(this.numClasses);
    }

    protected CandidateSplitsForLeaf getNewCandidateSplitsForLeaf(int numFeatures, int numInstances) {
        return new DecisionCandidateSplitsForLeaf(numFeatures, numInstances, this.numClasses);
    }

    protected Histogram getNewHistogram(Feature f) {
        return new DecisionHistogram(f, this.numClasses);
    }

    protected void setBestThresholdForSplit(TreeSplit split, Histogram histogram) {
        int c;
        DecisionHistogram decisionHistogram = (DecisionHistogram)histogram;
        DecisionTreeSplit decisionSplit = (DecisionTreeSplit)split;
        int nonZeroClassCount = 0;
        for (int c2 = 0; c2 < this.numClasses; ++c2) {
            if (!(decisionHistogram.targetDist[c2] > 0.0)) continue;
            ++nonZeroClassCount;
        }
        if (nonZeroClassCount == 1) {
            split.gain = 0.0;
            return;
        }
        double minSplitEntropy = Double.POSITIVE_INFINITY;
        int bestThreshold = 0;
        int leftCount = 0;
        histogram.splittable = false;
        double[] leftTargetDist = new double[this.numClasses];
        double[] rightTargetDist = new double[this.numClasses];
        System.arraycopy(decisionHistogram.targetDist, 0, rightTargetDist, 0, this.numClasses);
        Arrays.fill(decisionSplit.leftTargetDist, 0.0);
        for (int t = 0; t < histogram.numValues - 1; ++t) {
            leftCount += histogram.perValueCount[t];
            for (c = 0; c < this.numClasses; ++c) {
                int n = c;
                leftTargetDist[n] = leftTargetDist[n] + decisionHistogram.perValueTargetDist[t][c];
                int n2 = c;
                rightTargetDist[n2] = rightTargetDist[n2] - decisionHistogram.perValueTargetDist[t][c];
            }
            if (leftCount < this.minInstancesPerLeaf || leftCount == 0) continue;
            int rightCount = histogram.totalCount - leftCount;
            if (rightCount < this.minInstancesPerLeaf || rightCount == 0) break;
            histogram.splittable = true;
            double currentSplitEntropy = Entropy.getSplitEntropy(leftTargetDist, rightTargetDist);
            if (!(currentSplitEntropy < minSplitEntropy)) continue;
            bestThreshold = t;
            minSplitEntropy = currentSplitEntropy;
            for (int c3 = 0; c3 < this.numClasses; ++c3) {
                decisionSplit.leftTargetDist[c3] = leftTargetDist[c3];
            }
        }
        Feature feature = this.curTrainSet.dataset.features[split.feature];
        split.threshold = feature.upperBounds[bestThreshold];
        split.originalThreshold = feature.getOriginalValue(split.threshold);
        for (c = 0; c < this.numClasses; ++c) {
            decisionSplit.rightTargetDist[c] = decisionHistogram.targetDist[c] - decisionSplit.leftTargetDist[c];
        }
        split.gain = Double.isInfinite(minSplitEntropy) ? Double.NEGATIVE_INFINITY : Entropy.getEntropy(decisionHistogram.targetDist) - minSplitEntropy;
    }
}

