/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.boosting;

import edu.uci.jforests.config.ComponentConfig;
import edu.uci.jforests.util.ConfigHolder;
import java.util.Map;

public class LambdaMARTConfig
extends ComponentConfig {
    private static final String SIGMOID_BINS = "lambdamart.sigmoid-bins";
    public int sigmoidBins = 1000000;
    private static final String MAX_DCG_TRUNCATION = "lambdamart.max-dcg-truncation";
    public int maxDCGTruncation = 50;
    private static final String COST_FUNCTION = "lambdamart.cost-function";
    public String costFunction = "cross-entropy";

    public void init(ConfigHolder config) {
        for (Map.Entry<Object, Object> entry : config.getEntries()) {
            String key = ((String)entry.getKey()).toLowerCase();
            String value = ((String)entry.getValue()).trim();
            if (key.equals(SIGMOID_BINS)) {
                this.sigmoidBins = Integer.parseInt(value);
                continue;
            }
            if (key.equals(MAX_DCG_TRUNCATION)) {
                this.maxDCGTruncation = Integer.parseInt(value);
                continue;
            }
            if (!key.equals(COST_FUNCTION)) continue;
            this.costFunction = value;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("lambdamart.sigmoid-bins: " + this.sigmoidBins + "\n");
        sb.append("lambdamart.max-dcg-truncation: " + this.maxDCGTruncation + "\n");
        sb.append("lambdamart.cost-function: " + this.costFunction);
        return sb.toString();
    }
}

