/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning.boosting;

import edu.uci.jforests.config.ComponentConfig;
import edu.uci.jforests.util.ConfigHolder;
import java.util.Map;

public class GradientBoostingConfig
extends ComponentConfig {
    private static final String NUM_TREES = "boosting.num-trees";
    public int numTrees = 100;
    private static final String LEARNING_RATE = "boosting.learning-rate";
    public double learningRate = 1.0;
    private static final String IMBALANCE_COST_ADJUSTMENT = "boosting.imbalance-cost-adjustment";
    public boolean imbalanceCostAdjustment = true;
    private static final String SAMPLING_RATE = "boosting.sub-sampling";
    public double samplingRate = 1.0;
    private static final String EARLY_STOPPING_TOLERANCE = "boosting.early-stopping-tolerance";
    public double earlyStoppingTolerance = 0.0;

    public void init(ConfigHolder config) {
        for (Map.Entry<Object, Object> entry : config.getEntries()) {
            String key = ((String)entry.getKey()).toLowerCase();
            String value = (String)entry.getValue();
            if (key.equals(NUM_TREES)) {
                this.numTrees = Integer.parseInt(value);
                continue;
            }
            if (key.equals(LEARNING_RATE)) {
                this.learningRate = Double.parseDouble(value);
                continue;
            }
            if (key.equals(IMBALANCE_COST_ADJUSTMENT)) {
                this.imbalanceCostAdjustment = value.equals("true");
                continue;
            }
            if (key.equals(SAMPLING_RATE)) {
                this.samplingRate = Double.parseDouble(value);
                continue;
            }
            if (!key.equals(EARLY_STOPPING_TOLERANCE)) continue;
            this.earlyStoppingTolerance = Double.parseDouble(value);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("boosting.num-trees: " + this.numTrees + "\n");
        sb.append("boosting.learning-rate: " + this.learningRate + "\n");
        sb.append("boosting.imbalance-cost-adjustment: " + this.imbalanceCostAdjustment + "\n");
        sb.append("boosting.sub-sampling: " + this.samplingRate);
        sb.append("boosting.early-stopping-tolerance: " + this.earlyStoppingTolerance + "\n");
        return sb.toString();
    }
}

