/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.learning;

import edu.uci.jforests.eval.EvaluationMetric;
import edu.uci.jforests.learning.LearningProgressListener;
import edu.uci.jforests.learning.trees.Ensemble;
import edu.uci.jforests.learning.trees.Tree;
import edu.uci.jforests.learning.trees.TreeLeafInstances;
import edu.uci.jforests.sample.Sample;

public abstract class LearningModule {
    protected String algorithmName;
    protected int moduleLevel = 1;
    protected LearningModule subLearner;
    protected LearningModule parentLearner;
    protected double treeWeight = 1.0;
    protected EvaluationMetric evaluationMetric;
    protected LearningProgressListener progressListener;
    private double bestPrintedValidMeasurement = Double.NaN;

    public LearningModule(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public void setProgressListener(LearningProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public abstract Ensemble learn(Sample var1, Sample var2) throws Exception;

    public abstract double getValidationMeasurement() throws Exception;

    public void postProcess(Tree tree, TreeLeafInstances treeLeafInstances) {
    }

    public void setSubModule(LearningModule subModule) {
        this.subLearner = subModule;
        this.subLearner.setParentModule(this);
        this.subLearner.moduleLevel = this.moduleLevel + 1;
    }

    public void setParentModule(LearningModule parentModule) {
        this.parentLearner = parentModule;
    }

    public void setTreeWeight(double treeWeight) {
        this.treeWeight = treeWeight;
    }

    public void setAlgorithmName(String name) {
        this.algorithmName = name;
    }

    public void printTrainAndValidMeasurement(int iteration, double validMeasurement, double trainMeasurement, EvaluationMetric evaluationMetric) {
        if (evaluationMetric.isFirstBetter(validMeasurement, this.bestPrintedValidMeasurement, 0.0)) {
            this.bestPrintedValidMeasurement = validMeasurement;
        }
        if (this.moduleLevel > 1) {
            return;
        }
        for (int i = 0; i < this.moduleLevel - 1; ++i) {
            System.out.print("\t");
        }
        if (Double.isNaN(trainMeasurement)) {
            System.out.println(this.algorithmName + ": [Iteration: " + iteration + ", Valid: " + validMeasurement + ", Best: " + this.bestPrintedValidMeasurement + "]");
        } else {
            System.out.println(iteration + "\t" + validMeasurement + "\t" + trainMeasurement);
        }
    }

    public void printValidMeasurement(int iteration, double validMeasurement, EvaluationMetric evaluationMetric) {
        this.printTrainAndValidMeasurement(iteration, validMeasurement, Double.NaN, evaluationMetric);
    }

    protected void onIterationEnd() {
        if (this.progressListener != null) {
            this.progressListener.onIterationEnd();
        }
    }

    protected void onLearningEnd() {
    }
}

