/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.input;

import edu.uci.jforests.dataset.Feature;
import edu.uci.jforests.input.BinaryFileWriter;

public class RankingBinFileWriter
extends BinaryFileWriter {
    private int[] queryBoundaries;

    public RankingBinFileWriter(String binFileName, Feature[] features, double[] targets, int[] queryBoundaries) {
        super(binFileName, features, targets);
        this.queryBoundaries = queryBoundaries;
    }

    protected void writeHeader() {
        super.writeHeader();
        int numQueries = this.queryBoundaries.length - 1;
        this.writeInt(numQueries);
    }

    public void write() {
        super.write();
        for (int q = 0; q < this.queryBoundaries.length; ++q) {
            this.writeInt(this.queryBoundaries[q]);
        }
    }
}

