/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.input;

import edu.uci.jforests.input.BinaryFileGenerator;
import edu.uci.jforests.input.RankingBinFileWriter;
import edu.uci.jforests.input.sparse.SparseTextFileLine;
import edu.uci.jforests.util.ArraysUtil;
import java.util.ArrayList;
import java.util.List;

public class RankingBinFileGenerator
extends BinaryFileGenerator {
    private String prevQid = null;
    private int lineIndex = 0;
    private List<Integer> queryBoundaries = new ArrayList<Integer>();

    public RankingBinFileGenerator(String textFile, String featuresStatFile, String binFile) {
        super(textFile, featuresStatFile, binFile);
    }

    protected void handle(SparseTextFileLine line) {
        if (!line.qid.equals(this.prevQid)) {
            this.queryBoundaries.add(this.lineIndex);
        }
        this.prevQid = line.qid;
        ++this.lineIndex;
    }

    protected void loadValueHashMaps() {
        super.loadValueHashMaps();
        this.queryBoundaries.add(this.lineIndex);
    }

    protected void createBinFile() {
        this.writer = new RankingBinFileWriter(this.binFile, this.features, this.targets, ArraysUtil.toArray(this.queryBoundaries));
    }
}

