/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.input;

import edu.uci.jforests.input.FeatureAnalyzer;
import edu.uci.jforests.input.FeatureStatistics;

public class OriginalFeatureValues {
    private static final int MAX_FEATURE_VALUE = 32766;
    private double[] min;
    private double[] factor;
    private boolean[] onLogScale;

    public OriginalFeatureValues(String featuresStatFile) {
        FeatureAnalyzer featureAnalyzer = new FeatureAnalyzer();
        featureAnalyzer.loadFeaturesFromFile(featuresStatFile);
        int featureCount = featureAnalyzer.getFeatureCount();
        this.min = new double[featureCount];
        double[] max = new double[featureCount];
        for (int f = 0; f < featureCount; ++f) {
            FeatureStatistics stat = featureAnalyzer.getStatistics(f + 1);
            if (stat == null) {
                this.min[f] = 0.0;
                max[f] = 0.0;
                continue;
            }
            this.min[f] = stat.minValue;
            max[f] = stat.maxValue;
        }
        this.factor = new double[featureCount];
        this.onLogScale = new boolean[featureCount];
        for (int i = 0; i < featureCount; ++i) {
            double range = max[i] - this.min[i];
            if (range < 32766.0) {
                this.factor[i] = 32766.0 / range;
                continue;
            }
            this.factor[i] = 32766.0 / Math.log(range + 1.0);
            this.onLogScale[i] = true;
        }
    }

    public double getOriginalFeatureValue(int f, double value) {
        value /= this.factor[f];
        value = this.onLogScale[f] ? Math.exp(value) - 1.0 + this.min[f] : (value += this.min[f]);
        return value;
    }
}

