/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.input;

import edu.uci.jforests.input.FeatureAnalyzer;
import edu.uci.jforests.input.FeatureValuePair;
import edu.uci.jforests.input.sparse.SparseTextFileLine;
import edu.uci.jforests.input.sparse.SparseTextFileReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.zip.GZIPOutputStream;

public class DiscreteSparseTextFileGenerator {
    public static void convert(String inputFilename, String featuresStatFile, String outputFilename) {
        if (new File(outputFilename).exists()) {
            System.out.println("File: " + outputFilename + " already exists. Skipping it.");
            return;
        }
        FeatureAnalyzer featureAnalyzer = new FeatureAnalyzer();
        featureAnalyzer.loadFeaturesFromFile(featuresStatFile);
        StringBuilder sb = new StringBuilder();
        SparseTextFileReader reader = new SparseTextFileReader();
        SparseTextFileLine line = new SparseTextFileLine();
        reader.open(inputFilename);
        try {
            PrintStream output = outputFilename.endsWith(".gz") ? new PrintStream(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(new File(outputFilename))))) : new PrintStream(new File(outputFilename));
            int count = 0;
            while (reader.loadNextLine(line)) {
                if (line.meta) {
                    output.println(line.content);
                    continue;
                }
                sb.setLength(0);
                sb.append(line.target);
                if (line.qid != null) {
                    sb.append(" qid:" + line.qid);
                }
                for (int i = 0; i < line.numPairs; ++i) {
                    FeatureValuePair pair = line.pairs[i];
                    double value = pair.featureValue;
                    int idx = pair.featureIndex - 1;
                    value = featureAnalyzer.onLogScale[idx] ? Math.log(value - featureAnalyzer.min[idx] + 1.0) * featureAnalyzer.factor[idx] : (value - featureAnalyzer.min[idx]) * featureAnalyzer.factor[idx];
                    int intValue = (int)Math.round(value);
                    if (intValue == 0) continue;
                    sb.append(" " + pair.featureIndex + ":" + intValue);
                }
                output.println(sb.toString());
                if (++count % 10000 != 0) continue;
                System.out.println(count);
            }
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reader.close();
    }
}

