/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.eval.ranking;

import edu.uci.jforests.eval.EvaluationMetric;
import edu.uci.jforests.sample.Sample;

public abstract class RankingEvaluationMetric
extends EvaluationMetric {
    public static double[] computeNaturalOrderScores(int numTargets, int[] boundaries) {
        double[] naturalOrder = new double[numTargets];
        for (int q = 0; q < boundaries.length - 1; ++q) {
            int numDocs;
            int begin = boundaries[q];
            int nextScore = numDocs = boundaries[q + 1] - begin;
            for (int d = begin; d < begin + numDocs; ++d) {
                naturalOrder[d] = nextScore--;
            }
        }
        return naturalOrder;
    }

    public RankingEvaluationMetric(boolean isLargerBetter) {
        super(isLargerBetter);
    }

    public abstract SwapScorer getSwapScorer(double[] var1, int[] var2, int var3, int[][] var4) throws Exception;

    public abstract double[] measureByQuery(double[] var1, Sample var2) throws Exception;

    public double measure(double[] predictions, Sample sample) throws Exception {
        double[] result = this.measureByQuery(predictions, sample);
        double rtr = 0.0;
        for (int i = 0; i < result.length; ++i) {
            rtr += result[i];
        }
        return rtr /= (double)result.length;
    }

    public EvaluationMetric getParentMetric() {
        return this;
    }

    public static abstract class SwapScorer {
        double[] targets;
        int[] boundaries;
        int trunc;
        int[][] labelCounts;

        SwapScorer(double[] targets, int[] boundaries, int trunc, int[][] labelCounts) {
            this.targets = targets;
            this.boundaries = boundaries;
            this.trunc = trunc;
            this.labelCounts = labelCounts;
        }

        public abstract double getDelta(int var1, int var2, int var3, int var4, int var5);

        public void setCurrentIterationEvaluation(int iteration, double[] nDCG) {
        }

        public int[] getQueryBoundaries() {
            return this.boundaries;
        }
    }
}

