/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.jforests.eval;

import edu.uci.jforests.eval.EvaluationMetric;
import edu.uci.jforests.sample.Sample;
import java.util.ArrayList;
import java.util.Collections;

public class AUC
extends EvaluationMetric {
    public AUC() {
        super(true);
    }

    public double measure(double[] predictions, Sample sample) {
        int totalPositive = 0;
        int totalNegative = 0;
        ArrayList<DoubleDoublePair> sortedProb = new ArrayList<DoubleDoublePair>();
        for (int i = 0; i < sample.size; ++i) {
            double label = sample.targets[i];
            sortedProb.add(new DoubleDoublePair(predictions[i], label));
            if (label == 0.0) {
                ++totalNegative;
                continue;
            }
            ++totalPositive;
        }
        Collections.sort(sortedProb);
        double fp = 0.0;
        double tp = 0.0;
        double fpPrev = 0.0;
        double tpPrev = 0.0;
        double area = 0.0;
        double fPrev = Double.MIN_VALUE;
        for (int i = 0; i < sortedProb.size(); ++i) {
            double label;
            DoubleDoublePair pair = (DoubleDoublePair)sortedProb.get(i);
            double curF = pair.key;
            if (curF != fPrev) {
                area += Math.abs(fp - fpPrev) * ((tp + tpPrev) / 2.0);
                fPrev = curF;
                fpPrev = fp;
                tpPrev = tp;
            }
            if ((label = pair.value) == 1.0) {
                tp += 1.0;
                continue;
            }
            fp += 1.0;
        }
        area += Math.abs((double)totalNegative - fpPrev) * (((double)totalPositive + tpPrev) / 2.0);
        return area /= (double)totalPositive * (double)totalNegative;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleDoublePair
    implements Comparable<DoubleDoublePair> {
        public double key;
        public double value;

        public DoubleDoublePair(double key, double value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(DoubleDoublePair o) {
            if (this.key > o.key) {
                return -1;
            }
            if (this.key < o.key) {
                return 1;
            }
            return 0;
        }
    }
}

