/*
 * Decompiled with CFR 0.152.
 */
package com.github.yasevich.endlessrecyclerview;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public final class EndlessRecyclerView
extends RecyclerView {
    private final Handler handler = new Handler();
    private final Runnable notifyDataSetChangedRunnable = new Runnable(){

        @Override
        public void run() {
            EndlessRecyclerView.this.adapterWrapper.notifyDataSetChanged();
        }
    };
    private EndlessScrollListener endlessScrollListener;
    private LayoutManagerWrapper layoutManagerWrapper;
    private AdapterWrapper adapterWrapper;
    private View progressView;
    private boolean refreshing;
    private int threshold = 1;

    public EndlessRecyclerView(Context context) {
        this(context, null);
    }

    public EndlessRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EndlessRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        this.adapterWrapper = new AdapterWrapper((RecyclerView.Adapter<RecyclerView.ViewHolder>)adapter);
        super.setAdapter((RecyclerView.Adapter)this.adapterWrapper);
    }

    public RecyclerView.Adapter getAdapter() {
        return this.adapterWrapper.getAdapter();
    }

    public void setLayoutManager(@Nullable RecyclerView.LayoutManager layout) {
        this.layoutManagerWrapper = layout == null ? null : new LayoutManagerWrapper(layout);
        super.setLayoutManager(layout);
    }

    public void setPager(Pager pager) {
        if (pager != null) {
            this.endlessScrollListener = new EndlessScrollListener(pager);
            this.endlessScrollListener.setThreshold(this.threshold);
            this.addOnScrollListener(this.endlessScrollListener);
        } else if (this.endlessScrollListener != null) {
            this.removeOnScrollListener(this.endlessScrollListener);
            this.endlessScrollListener = null;
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
        if (this.endlessScrollListener != null) {
            this.endlessScrollListener.setThreshold(threshold);
        }
    }

    public void setProgressView(int layoutResId) {
        this.setProgressView(LayoutInflater.from((Context)this.getContext()).inflate(layoutResId, (ViewGroup)this, false));
    }

    public void setProgressView(View view) {
        this.progressView = view;
    }

    public void setRefreshing(boolean refreshing) {
        if (this.refreshing == refreshing) {
            return;
        }
        this.refreshing = refreshing;
        this.notifyDataSetChanged();
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    private void notifyDataSetChanged() {
        if (this.isComputingLayout()) {
            this.handler.post(this.notifyDataSetChangedRunnable);
        } else {
            this.adapterWrapper.notifyDataSetChanged();
        }
    }

    public static interface Pager {
        public boolean shouldLoad();

        public void loadNextPage();
    }

    private final class AdapterWrapper
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private static final int PROGRESS_VIEW_TYPE = -1;
        private final RecyclerView.Adapter<RecyclerView.ViewHolder> adapter;
        private ProgressViewHolder progressViewHolder;

        AdapterWrapper(RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
            if (adapter == null) {
                throw new NullPointerException("adapter is null");
            }
            this.adapter = adapter;
            this.setHasStableIds(adapter.hasStableIds());
        }

        public int getItemCount() {
            return this.adapter.getItemCount() + (EndlessRecyclerView.this.refreshing && EndlessRecyclerView.this.progressView != null ? 1 : 0);
        }

        public long getItemId(int position) {
            return position == this.adapter.getItemCount() ? -1L : this.adapter.getItemId(position);
        }

        public int getItemViewType(int position) {
            return EndlessRecyclerView.this.refreshing & position == this.adapter.getItemCount() ? -1 : this.adapter.getItemViewType(position);
        }

        public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
            super.onAttachedToRecyclerView(recyclerView);
            this.adapter.onAttachedToRecyclerView(recyclerView);
        }

        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            if (position < this.adapter.getItemCount()) {
                this.adapter.onBindViewHolder(holder, position);
            }
        }

        @NonNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            RecyclerView.ViewHolder viewHolder;
            if (viewType == -1) {
                this.progressViewHolder = new ProgressViewHolder();
                viewHolder = this.progressViewHolder;
            } else {
                viewHolder = this.adapter.onCreateViewHolder(parent, viewType);
            }
            return viewHolder;
        }

        public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
            super.onDetachedFromRecyclerView(recyclerView);
            this.adapter.onDetachedFromRecyclerView(recyclerView);
        }

        public boolean onFailedToRecycleView(@NonNull RecyclerView.ViewHolder holder) {
            return holder == this.progressViewHolder || this.adapter.onFailedToRecycleView(holder);
        }

        public void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
            if (holder == this.progressViewHolder) {
                return;
            }
            this.adapter.onViewAttachedToWindow(holder);
        }

        public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
            if (holder == this.progressViewHolder) {
                return;
            }
            this.adapter.onViewDetachedFromWindow(holder);
        }

        public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
            if (holder == this.progressViewHolder) {
                return;
            }
            this.adapter.onViewRecycled(holder);
        }

        public void registerAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
            super.registerAdapterDataObserver(observer);
            this.adapter.registerAdapterDataObserver(observer);
        }

        public void unregisterAdapterDataObserver(@NonNull RecyclerView.AdapterDataObserver observer) {
            super.unregisterAdapterDataObserver(observer);
            this.adapter.unregisterAdapterDataObserver(observer);
        }

        RecyclerView.Adapter<RecyclerView.ViewHolder> getAdapter() {
            return this.adapter;
        }

        private final class ProgressViewHolder
        extends RecyclerView.ViewHolder {
            ProgressViewHolder() {
                super(EndlessRecyclerView.this.progressView);
            }
        }
    }

    private final class EndlessScrollListener
    extends RecyclerView.OnScrollListener {
        private final Pager pager;
        private int threshold = 1;

        EndlessScrollListener(Pager pager) {
            if (pager == null) {
                throw new NullPointerException("pager is null");
            }
            this.pager = pager;
        }

        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
            RecyclerView.Adapter adapter = EndlessRecyclerView.this.getAdapter();
            if (adapter == null) {
                return;
            }
            int lastVisibleItemPosition = EndlessRecyclerView.this.layoutManagerWrapper.findLastVisibleItemPosition();
            int lastItemPosition = adapter.getItemCount();
            if (this.pager.shouldLoad() && lastItemPosition - lastVisibleItemPosition <= this.threshold) {
                EndlessRecyclerView.this.setRefreshing(true);
                this.pager.loadNextPage();
            }
        }

        void setThreshold(int threshold) {
            if (threshold <= 0) {
                throw new IllegalArgumentException("illegal threshold: " + threshold);
            }
            this.threshold = threshold;
        }
    }

    private static final class LayoutManagerWrapper {
        @NonNull
        final RecyclerView.LayoutManager layoutManager;
        @NonNull
        private final LayoutManagerResolver resolver;

        LayoutManagerWrapper(@NonNull RecyclerView.LayoutManager layoutManager) {
            this.layoutManager = layoutManager;
            this.resolver = LayoutManagerWrapper.getResolver(layoutManager);
        }

        @NonNull
        private static LayoutManagerResolver getResolver(@NonNull RecyclerView.LayoutManager layoutManager) {
            if (layoutManager instanceof LinearLayoutManager) {
                return new LayoutManagerResolver(){

                    @Override
                    public int findLastVisibleItemPosition(@NonNull RecyclerView.LayoutManager layoutManager) {
                        return ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                    }
                };
            }
            if (layoutManager instanceof StaggeredGridLayoutManager) {
                return new LayoutManagerResolver(){

                    @Override
                    public int findLastVisibleItemPosition(@NonNull RecyclerView.LayoutManager layoutManager) {
                        int[] lastVisibleItemPositions = ((StaggeredGridLayoutManager)layoutManager).findLastVisibleItemPositions(null);
                        int lastVisibleItemPosition = lastVisibleItemPositions[0];
                        for (int i = 1; i < lastVisibleItemPositions.length; ++i) {
                            if (lastVisibleItemPosition >= lastVisibleItemPositions[i]) continue;
                            lastVisibleItemPosition = lastVisibleItemPositions[i];
                        }
                        return lastVisibleItemPosition;
                    }
                };
            }
            throw new IllegalArgumentException("unsupported layout manager: " + layoutManager);
        }

        int findLastVisibleItemPosition() {
            return this.resolver.findLastVisibleItemPosition(this.layoutManager);
        }

        private static interface LayoutManagerResolver {
            public int findLastVisibleItemPosition(@NonNull RecyclerView.LayoutManager var1);
        }
    }
}

