/*
 * Decompiled with CFR 0.152.
 */
package com.github.yasevich.endlessrecyclerview;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;

public final class EndlessRecyclerView
extends RecyclerView {
    private final List<RecyclerView.OnScrollListener> onScrollListeners = new ArrayList<RecyclerView.OnScrollListener>();
    private EndlessScrollListener endlessScrollListener;
    private AdapterWrapper adapterWrapper;
    private View progressView;
    private boolean refreshing;
    private int threshold = 1;

    public EndlessRecyclerView(Context context) {
        this(context, null);
    }

    public EndlessRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EndlessRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        super.setOnScrollListener((RecyclerView.OnScrollListener)new OnScrollListenerImpl());
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        this.adapterWrapper = new AdapterWrapper((RecyclerView.Adapter<RecyclerView.ViewHolder>)adapter);
        super.setAdapter((RecyclerView.Adapter)this.adapterWrapper);
    }

    public RecyclerView.Adapter getAdapter() {
        return this.adapterWrapper.getAdapter();
    }

    public void setOnScrollListener(RecyclerView.OnScrollListener listener) {
        throw new UnsupportedOperationException("use addOnScrollListener(OnScrollListener) and removeOnScrollListener(OnScrollListener) instead");
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout) {
        if (!(layout instanceof LinearLayoutManager)) {
            throw new IllegalArgumentException("layout manager must be an instance of LinearLayoutManager");
        }
        super.setLayoutManager(layout);
    }

    public LinearLayoutManager getLayoutManager() {
        return (LinearLayoutManager)super.getLayoutManager();
    }

    public void addOnScrollListener(RecyclerView.OnScrollListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.onScrollListeners.add(listener);
    }

    public void removeOnScrollListener(RecyclerView.OnScrollListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.onScrollListeners.remove(listener);
    }

    public void setPager(Pager pager) {
        if (pager != null) {
            this.endlessScrollListener = new EndlessScrollListener(pager);
            this.endlessScrollListener.setThreshold(this.threshold);
            this.addOnScrollListener(this.endlessScrollListener);
        } else if (this.endlessScrollListener != null) {
            this.removeOnScrollListener(this.endlessScrollListener);
            this.endlessScrollListener = null;
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
        if (this.endlessScrollListener != null) {
            this.endlessScrollListener.setThreshold(threshold);
        }
    }

    public void setProgressView(int layoutResId) {
        this.setProgressView(LayoutInflater.from((Context)this.getContext()).inflate(layoutResId, (ViewGroup)this, false));
    }

    public void setProgressView(View view) {
        this.progressView = view;
    }

    public void setRefreshing(boolean refreshing) {
        if (this.refreshing == refreshing) {
            return;
        }
        this.refreshing = refreshing;
        this.adapterWrapper.notifyDataSetChanged();
    }

    public static interface Pager {
        public boolean shouldLoad();

        public void loadNextPage();
    }

    private final class AdapterWrapper
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private static final int PROGRESS_VIEW_TYPE = -1;
        private final RecyclerView.Adapter<RecyclerView.ViewHolder> adapter;
        private ProgressViewHolder progressViewHolder;

        public AdapterWrapper(RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
            if (adapter == null) {
                throw new NullPointerException("adapter is null");
            }
            this.adapter = adapter;
            this.setHasStableIds(adapter.hasStableIds());
        }

        public int getItemCount() {
            return this.adapter.getItemCount() + (EndlessRecyclerView.this.refreshing && EndlessRecyclerView.this.progressView != null ? 1 : 0);
        }

        public long getItemId(int position) {
            return position == this.adapter.getItemCount() ? -1L : this.adapter.getItemId(position);
        }

        public int getItemViewType(int position) {
            return EndlessRecyclerView.this.refreshing & position == this.adapter.getItemCount() ? -1 : this.adapter.getItemViewType(position);
        }

        public void onAttachedToRecyclerView(RecyclerView recyclerView) {
            super.onAttachedToRecyclerView(recyclerView);
            this.adapter.onAttachedToRecyclerView(recyclerView);
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (position < this.adapter.getItemCount()) {
                this.adapter.onBindViewHolder(holder, position);
            }
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            RecyclerView.ViewHolder viewHolder;
            if (viewType == -1) {
                this.progressViewHolder = new ProgressViewHolder();
                viewHolder = this.progressViewHolder;
            } else {
                viewHolder = this.adapter.onCreateViewHolder(parent, viewType);
            }
            return viewHolder;
        }

        public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
            super.onDetachedFromRecyclerView(recyclerView);
            this.adapter.onDetachedFromRecyclerView(recyclerView);
        }

        public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
            return holder == this.progressViewHolder || this.adapter.onFailedToRecycleView(holder);
        }

        public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
            if (holder == this.progressViewHolder) {
                return;
            }
            this.adapter.onViewAttachedToWindow(holder);
        }

        public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
            if (holder == this.progressViewHolder) {
                return;
            }
            this.adapter.onViewDetachedFromWindow(holder);
        }

        public void onViewRecycled(RecyclerView.ViewHolder holder) {
            if (holder == this.progressViewHolder) {
                return;
            }
            this.adapter.onViewRecycled(holder);
        }

        public void registerAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
            super.registerAdapterDataObserver(observer);
            this.adapter.registerAdapterDataObserver(observer);
        }

        public void unregisterAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
            super.unregisterAdapterDataObserver(observer);
            this.adapter.unregisterAdapterDataObserver(observer);
        }

        public RecyclerView.Adapter<RecyclerView.ViewHolder> getAdapter() {
            return this.adapter;
        }

        private final class ProgressViewHolder
        extends RecyclerView.ViewHolder {
            public ProgressViewHolder() {
                super(EndlessRecyclerView.this.progressView);
            }
        }
    }

    private final class EndlessScrollListener
    extends RecyclerView.OnScrollListener {
        private final Pager pager;
        private int threshold = 1;

        public EndlessScrollListener(Pager pager) {
            if (pager == null) {
                throw new NullPointerException("pager is null");
            }
            this.pager = pager;
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            int lastVisibleItemPosition = EndlessRecyclerView.this.getLayoutManager().findLastVisibleItemPosition();
            int lastItemPosition = EndlessRecyclerView.this.getAdapter().getItemCount();
            if (this.pager.shouldLoad() && lastItemPosition - lastVisibleItemPosition <= this.threshold) {
                EndlessRecyclerView.this.setRefreshing(true);
                this.pager.loadNextPage();
            }
        }

        public void setThreshold(int threshold) {
            if (threshold <= 0) {
                throw new IllegalArgumentException("illegal threshold: " + threshold);
            }
            this.threshold = threshold;
        }
    }

    private final class OnScrollListenerImpl
    extends RecyclerView.OnScrollListener {
        private OnScrollListenerImpl() {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            for (RecyclerView.OnScrollListener listener : EndlessRecyclerView.this.onScrollListeners) {
                listener.onScrolled(recyclerView, dx, dy);
            }
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            for (RecyclerView.OnScrollListener listener : EndlessRecyclerView.this.onScrollListeners) {
                listener.onScrollStateChanged(recyclerView, newState);
            }
        }
    }
}

