/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.lovelydialog;

import android.content.Context;
import android.view.View;
import android.widget.Button;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.yarolegovich.lovelydialog.AbsLovelyDialog;
import com.yarolegovich.lovelydialog.R;

public class LovelyStandardDialog
extends AbsLovelyDialog<LovelyStandardDialog> {
    public static final int POSITIVE_BUTTON = R.id.ld_btn_yes;
    public static final int NEGATIVE_BUTTON = R.id.ld_btn_no;
    public static final int NEUTRAL_BUTTON = R.id.ld_btn_neutral;
    private Button positiveButton = (Button)this.findView(R.id.ld_btn_yes);
    private Button negativeButton = (Button)this.findView(R.id.ld_btn_no);
    private Button neutralButton = (Button)this.findView(R.id.ld_btn_neutral);

    public LovelyStandardDialog(Context context) {
        super(context);
    }

    public LovelyStandardDialog(Context context, int theme) {
        super(context, theme);
    }

    public LovelyStandardDialog(Context context, ButtonLayout buttonLayout) {
        super(context, 0, buttonLayout.layoutRes);
    }

    public LovelyStandardDialog(Context context, int theme, ButtonLayout buttonLayout) {
        super(context, theme, buttonLayout.layoutRes);
    }

    public LovelyStandardDialog setPositiveButton(@StringRes int text, View.OnClickListener listener) {
        return this.setPositiveButton(this.string(text), listener);
    }

    public LovelyStandardDialog setPositiveButton(String text, @Nullable View.OnClickListener listener) {
        this.positiveButton.setVisibility(0);
        this.positiveButton.setText((CharSequence)text);
        this.positiveButton.setOnClickListener((View.OnClickListener)new AbsLovelyDialog.ClickListenerDecorator(this, listener, true));
        return this;
    }

    public LovelyStandardDialog setNegativeButtonText(@StringRes int text) {
        return this.setNegativeButton(this.string(text), null);
    }

    public LovelyStandardDialog setNegativeButtonText(String text) {
        return this.setNegativeButton(text, null);
    }

    public LovelyStandardDialog setNegativeButton(@StringRes int text, View.OnClickListener listener) {
        return this.setNegativeButton(this.string(text), listener);
    }

    public LovelyStandardDialog setNegativeButton(String text, @Nullable View.OnClickListener listener) {
        this.negativeButton.setVisibility(0);
        this.negativeButton.setText((CharSequence)text);
        this.negativeButton.setOnClickListener((View.OnClickListener)new AbsLovelyDialog.ClickListenerDecorator(this, listener, true));
        return this;
    }

    public LovelyStandardDialog setNeutralButtonText(@StringRes int text) {
        return this.setNeutralButton(this.string(text), null);
    }

    public LovelyStandardDialog setNeutralButtonText(String text) {
        return this.setNeutralButton(text, null);
    }

    public LovelyStandardDialog setNeutralButton(@StringRes int text, @Nullable View.OnClickListener listener) {
        return this.setNeutralButton(this.string(text), listener);
    }

    public LovelyStandardDialog setNeutralButton(String text, @Nullable View.OnClickListener listener) {
        this.neutralButton.setVisibility(0);
        this.neutralButton.setText((CharSequence)text);
        this.neutralButton.setOnClickListener((View.OnClickListener)new AbsLovelyDialog.ClickListenerDecorator(this, listener, true));
        return this;
    }

    public LovelyStandardDialog setButtonsColor(@ColorInt int color) {
        this.positiveButton.setTextColor(color);
        this.negativeButton.setTextColor(color);
        this.neutralButton.setTextColor(color);
        return this;
    }

    public LovelyStandardDialog setButtonsColorRes(@ColorRes int colorRes) {
        return this.setButtonsColor(this.color(colorRes));
    }

    public LovelyStandardDialog setOnButtonClickListener(View.OnClickListener listener) {
        return this.setOnButtonClickListener(true, listener);
    }

    public LovelyStandardDialog setOnButtonClickListener(boolean closeOnClick, View.OnClickListener listener) {
        AbsLovelyDialog.ClickListenerDecorator clickHandler = new AbsLovelyDialog.ClickListenerDecorator(this, listener, closeOnClick);
        this.positiveButton.setOnClickListener((View.OnClickListener)clickHandler);
        this.neutralButton.setOnClickListener((View.OnClickListener)clickHandler);
        this.negativeButton.setOnClickListener((View.OnClickListener)clickHandler);
        return this;
    }

    public LovelyStandardDialog setPositiveButtonText(@StringRes int text) {
        return this.setPositiveButton(this.string(text), null);
    }

    public LovelyStandardDialog setPositiveButtonText(String text) {
        return this.setPositiveButton(text, null);
    }

    public LovelyStandardDialog setPositiveButtonColor(@ColorInt int color) {
        this.positiveButton.setTextColor(color);
        return this;
    }

    public LovelyStandardDialog setNegativeButtonColor(@ColorInt int color) {
        this.negativeButton.setTextColor(color);
        return this;
    }

    public LovelyStandardDialog setNeutralButtonColor(@ColorInt int color) {
        this.neutralButton.setTextColor(color);
        return this;
    }

    public LovelyStandardDialog setPositiveButtonColorRes(@ColorRes int colorRes) {
        return this.setPositiveButtonColor(this.color(colorRes));
    }

    public LovelyStandardDialog setNegativeButtonColorRes(@ColorRes int colorRes) {
        return this.setNegativeButtonColor(this.color(colorRes));
    }

    public LovelyStandardDialog setNeutralButtonColorRes(@ColorRes int colorRes) {
        return this.setNeutralButtonColor(this.color(colorRes));
    }

    @Override
    protected int getLayout() {
        return ButtonLayout.HORIZONTAL.layoutRes;
    }

    public static enum ButtonLayout {
        HORIZONTAL(R.layout.dialog_standard),
        VERTICAL(R.layout.dialog_standard_vertical);

        @LayoutRes
        final int layoutRes;

        private ButtonLayout(int layoutRes) {
            this.layoutRes = layoutRes;
        }
    }
}

