/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.lovelydialog;

import android.os.Bundle;
import android.util.SparseArray;
import com.yarolegovich.lovelydialog.AbsLovelyDialog;
import java.lang.ref.WeakReference;

public class LovelySaveStateHandler {
    private static final String KEY_DIALOG_ID = "id";
    private SparseArray<WeakReference<AbsLovelyDialog<?>>> handledDialogs = new SparseArray();

    public void saveInstanceState(Bundle outState) {
        for (int index = this.handledDialogs.size() - 1; index >= 0; --index) {
            WeakReference dialogRef = (WeakReference)this.handledDialogs.valueAt(index);
            if (dialogRef.get() == null) {
                this.handledDialogs.remove(index);
                continue;
            }
            AbsLovelyDialog dialog = (AbsLovelyDialog)dialogRef.get();
            if (!dialog.isShowing()) continue;
            dialog.onSaveInstanceState(outState);
            outState.putInt(KEY_DIALOG_ID, this.handledDialogs.keyAt(index));
            return;
        }
    }

    void handleDialogStateSave(int id2, AbsLovelyDialog<?> dialog) {
        this.handledDialogs.put(id2, new WeakReference(dialog));
    }

    public static boolean wasDialogOnScreen(Bundle savedInstanceState) {
        return savedInstanceState.keySet().contains(KEY_DIALOG_ID);
    }

    public static int getSavedDialogId(Bundle savedInstanceState) {
        return savedInstanceState.getInt(KEY_DIALOG_ID, -1);
    }
}

