/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.lovelydialog;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import com.yarolegovich.lovelydialog.AbsLovelyDialog;
import com.yarolegovich.lovelydialog.R;
import com.yarolegovich.lovelydialog.ViewConfigurator;

public class LovelyCustomDialog
extends AbsLovelyDialog<LovelyCustomDialog> {
    private View addedView;
    private InstanceStateManager instanceStateManager;

    public LovelyCustomDialog(Context context) {
        super(context);
    }

    public LovelyCustomDialog(Context context, int theme) {
        super(context, theme);
    }

    public LovelyCustomDialog setView(@LayoutRes int layout2) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        ViewGroup parent = (ViewGroup)this.findView(R.id.ld_custom_view_container);
        this.addedView = inflater.inflate(layout2, parent, true);
        return this;
    }

    public LovelyCustomDialog setView(View customView) {
        ViewGroup container = (ViewGroup)this.findView(R.id.ld_custom_view_container);
        container.addView(customView);
        this.addedView = customView;
        return this;
    }

    @Override
    public LovelyCustomDialog configureView(@NonNull ViewConfigurator<View> configurator) {
        if (this.addedView == null) {
            throw new IllegalStateException(this.string(R.string.ex_msg_dialog_view_not_set));
        }
        configurator.configureView(this.addedView);
        return this;
    }

    public LovelyCustomDialog setListener(int viewId, View.OnClickListener listener) {
        return this.setListener(viewId, false, listener);
    }

    public LovelyCustomDialog setListener(int viewId, boolean dismissOnClick, View.OnClickListener listener) {
        if (this.addedView == null) {
            throw new IllegalStateException(this.string(R.string.ex_msg_dialog_view_not_set));
        }
        AbsLovelyDialog.ClickListenerDecorator clickListener = new AbsLovelyDialog.ClickListenerDecorator(this, listener, dismissOnClick);
        this.findView(viewId).setOnClickListener((View.OnClickListener)clickListener);
        return this;
    }

    public LovelyCustomDialog setInstanceStateManager(InstanceStateManager instanceStateManager) {
        this.instanceStateManager = instanceStateManager;
        return this;
    }

    @Override
    void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.instanceStateManager.saveInstanceState(outState);
    }

    @Override
    void restoreState(Bundle savedState) {
        super.restoreState(savedState);
        this.instanceStateManager.restoreInstanceState(savedState);
    }

    @Override
    protected int getLayout() {
        return R.layout.dialog_custom;
    }

    public static interface InstanceStateManager {
        public void saveInstanceState(Bundle var1);

        public void restoreInstanceState(Bundle var1);
    }
}

