/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.lovelydialog;

import android.content.Context;
import android.os.Bundle;
import android.util.SparseBooleanArray;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.StringRes;
import com.yarolegovich.lovelydialog.AbsLovelyDialog;
import com.yarolegovich.lovelydialog.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LovelyChoiceDialog
extends AbsLovelyDialog<LovelyChoiceDialog> {
    private static final String KEY_ITEM_CHECKED_STATES = "key_item_checked_states";
    private ListView choicesList = (ListView)this.findView(R.id.ld_choices);
    private TextView confirmButton;

    public LovelyChoiceDialog(Context context) {
        super(context);
    }

    public LovelyChoiceDialog(Context context, int theme) {
        super(context, theme);
    }

    public <T> LovelyChoiceDialog setItems(T[] items, OnItemSelectedListener<T> itemSelectedListener) {
        return this.setItems(Arrays.asList(items), itemSelectedListener);
    }

    public <T> LovelyChoiceDialog setItems(List<T> items, OnItemSelectedListener<T> itemSelectedListener) {
        ArrayAdapter adapter = new ArrayAdapter(this.getContext(), R.layout.item_simple_text, 16908308, items);
        return this.setItems(adapter, itemSelectedListener);
    }

    public <T> LovelyChoiceDialog setItems(ArrayAdapter<T> adapter, OnItemSelectedListener<T> itemSelectedListener) {
        this.choicesList.setOnItemClickListener(new ItemSelectedAdapter(itemSelectedListener));
        this.choicesList.setAdapter(adapter);
        return this;
    }

    public <T> LovelyChoiceDialog setItemsMultiChoice(T[] items, OnItemsSelectedListener<T> itemsSelectedListener) {
        return this.setItemsMultiChoice(items, null, itemsSelectedListener);
    }

    public <T> LovelyChoiceDialog setItemsMultiChoice(T[] items, boolean[] selectionState, OnItemsSelectedListener<T> itemsSelectedListener) {
        return this.setItemsMultiChoice(Arrays.asList(items), selectionState, itemsSelectedListener);
    }

    public <T> LovelyChoiceDialog setItemsMultiChoice(List<T> items, OnItemsSelectedListener<T> itemsSelectedListener) {
        return this.setItemsMultiChoice(items, null, itemsSelectedListener);
    }

    public <T> LovelyChoiceDialog setItemsMultiChoice(List<T> items, boolean[] selectionState, OnItemsSelectedListener<T> itemsSelectedListener) {
        ArrayAdapter adapter = new ArrayAdapter(this.getContext(), R.layout.item_simple_text_multichoice, 16908308, items);
        return this.setItemsMultiChoice(adapter, selectionState, itemsSelectedListener);
    }

    public <T> LovelyChoiceDialog setItemsMultiChoice(ArrayAdapter<T> adapter, OnItemsSelectedListener<T> itemsSelectedListener) {
        return this.setItemsMultiChoice(adapter, null, itemsSelectedListener);
    }

    public <T> LovelyChoiceDialog setItemsMultiChoice(ArrayAdapter<T> adapter, boolean[] selectionState, OnItemsSelectedListener<T> itemsSelectedListener) {
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        View confirmBtnContainer = inflater.inflate(R.layout.item_footer_confirm, null);
        this.confirmButton = (TextView)confirmBtnContainer.findViewById(R.id.ld_btn_confirm);
        this.confirmButton.setOnClickListener(new ItemsSelectedAdapter(itemsSelectedListener));
        this.choicesList.addFooterView(confirmBtnContainer);
        ListView choicesList = (ListView)this.findView(R.id.ld_choices);
        choicesList.setChoiceMode(2);
        choicesList.setAdapter(adapter);
        if (selectionState != null) {
            for (int i = 0; i < selectionState.length; ++i) {
                choicesList.setItemChecked(i, selectionState[i]);
            }
        }
        return this;
    }

    public LovelyChoiceDialog setConfirmButtonText(@StringRes int text) {
        return this.setConfirmButtonText(this.string(text));
    }

    public LovelyChoiceDialog setConfirmButtonText(String text) {
        if (this.confirmButton == null) {
            throw new IllegalStateException(this.string(R.string.ex_msg_dialog_choice_confirm));
        }
        this.confirmButton.setText((CharSequence)text);
        return this;
    }

    public LovelyChoiceDialog setConfirmButtonColor(int color) {
        if (this.confirmButton == null) {
            throw new IllegalStateException(this.string(R.string.ex_msg_dialog_choice_confirm));
        }
        this.confirmButton.setTextColor(color);
        return this;
    }

    @Override
    void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.isMultiChoiceList()) {
            ListAdapter adapter = this.choicesList.getAdapter();
            boolean[] checkedStates = new boolean[adapter.getCount()];
            SparseBooleanArray checkedPositions = this.choicesList.getCheckedItemPositions();
            for (int i = 0; i < checkedPositions.size(); ++i) {
                if (!checkedPositions.valueAt(i)) continue;
                checkedStates[checkedPositions.keyAt((int)i)] = true;
            }
            outState.putBooleanArray(KEY_ITEM_CHECKED_STATES, checkedStates);
        }
    }

    @Override
    void restoreState(Bundle savedState) {
        super.restoreState(savedState);
        if (this.isMultiChoiceList()) {
            boolean[] checkedStates = savedState.getBooleanArray(KEY_ITEM_CHECKED_STATES);
            if (checkedStates == null) {
                return;
            }
            for (int index = 0; index < checkedStates.length; ++index) {
                this.choicesList.setItemChecked(index, checkedStates[index]);
            }
        }
    }

    @Override
    protected int getLayout() {
        return R.layout.dialog_choice;
    }

    private boolean isMultiChoiceList() {
        return this.choicesList.getChoiceMode() == 2;
    }

    public static interface OnItemsSelectedListener<T> {
        public void onItemsSelected(List<Integer> var1, List<T> var2);
    }

    private class ItemsSelectedAdapter<T>
    implements View.OnClickListener {
        private OnItemsSelectedListener<T> adaptee;

        private ItemsSelectedAdapter(OnItemsSelectedListener<T> adaptee) {
            this.adaptee = adaptee;
        }

        public void onClick(View v) {
            if (this.adaptee != null) {
                SparseBooleanArray checkedItemPositions = LovelyChoiceDialog.this.choicesList.getCheckedItemPositions();
                ArrayList<Object> selectedItems = new ArrayList<Object>(checkedItemPositions.size());
                ArrayList<Integer> selectedPositions = new ArrayList<Integer>(checkedItemPositions.size());
                ListAdapter adapter = LovelyChoiceDialog.this.choicesList.getAdapter();
                for (int index = 0; index < adapter.getCount(); ++index) {
                    if (!checkedItemPositions.get(index)) continue;
                    selectedPositions.add(index);
                    selectedItems.add(adapter.getItem(index));
                }
                this.adaptee.onItemsSelected(selectedPositions, selectedItems);
            }
            LovelyChoiceDialog.this.dismiss();
        }
    }

    public static interface OnItemSelectedListener<T> {
        public void onItemSelected(int var1, T var2);
    }

    private class ItemSelectedAdapter<T>
    implements AdapterView.OnItemClickListener {
        private OnItemSelectedListener<T> adaptee;

        private ItemSelectedAdapter(OnItemSelectedListener<T> adaptee) {
            this.adaptee = adaptee;
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            if (this.adaptee != null) {
                this.adaptee.onItemSelected(position, parent.getItemAtPosition(position));
            }
            LovelyChoiceDialog.this.dismiss();
        }
    }
}

