/*
 * Decompiled with CFR 0.152.
 */
package com.yarolegovich.lovelydialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import com.yarolegovich.lovelydialog.LovelyDialogCompat;
import com.yarolegovich.lovelydialog.LovelySaveStateHandler;
import com.yarolegovich.lovelydialog.R;
import com.yarolegovich.lovelydialog.ViewConfigurator;

public abstract class AbsLovelyDialog<T extends AbsLovelyDialog> {
    private static final String KEY_SAVED_STATE_TOKEN = "key_saved_state_token";
    private Dialog dialog;
    private View dialogView;
    private ImageView iconView;
    private TextView topTitleView;
    private TextView titleView;
    private TextView messageView;

    public AbsLovelyDialog(Context context) {
        this(context, 0);
    }

    public AbsLovelyDialog(Context context, int theme) {
        this(context, theme, 0);
    }

    public AbsLovelyDialog(Context context, int theme, int layoutRes) {
        if (layoutRes == 0) {
            layoutRes = this.getLayout();
        }
        if (theme == 0) {
            this.init(new AlertDialog.Builder(context), layoutRes);
        } else {
            this.init(new AlertDialog.Builder(context, theme), layoutRes);
        }
    }

    private void init(AlertDialog.Builder dialogBuilder, @LayoutRes int res) {
        this.dialogView = LayoutInflater.from((Context)dialogBuilder.getContext()).inflate(res, null);
        this.dialog = dialogBuilder.setView(this.dialogView).create();
        this.iconView = (ImageView)this.findView(R.id.ld_icon);
        this.titleView = (TextView)this.findView(R.id.ld_title);
        this.messageView = (TextView)this.findView(R.id.ld_message);
        this.topTitleView = (TextView)this.findView(R.id.ld_top_title);
    }

    @LayoutRes
    protected abstract int getLayout();

    public T configureView(@NonNull ViewConfigurator<View> viewViewConfigurator) {
        viewViewConfigurator.configureView(this.dialogView);
        return (T)this;
    }

    public T configureTitleView(@NonNull ViewConfigurator<TextView> viewConfigurator) {
        viewConfigurator.configureView(this.titleView);
        return (T)this;
    }

    public T configureMessageView(@NonNull ViewConfigurator<TextView> viewConfigurator) {
        viewConfigurator.configureView(this.messageView);
        return (T)this;
    }

    public T setMessage(@StringRes int message) {
        return this.setMessage(this.string(message));
    }

    public T setMessage(CharSequence message) {
        this.messageView.setVisibility(0);
        this.messageView.setText(message);
        return (T)this;
    }

    public T setTitle(@StringRes int title) {
        return this.setTitle(this.string(title));
    }

    public T setTopTitle(@StringRes int title) {
        return this.setTopTitle(this.string(title));
    }

    public T setTitle(CharSequence title) {
        this.titleView.setVisibility(0);
        this.titleView.setText(title);
        return (T)this;
    }

    public T setTopTitle(CharSequence title) {
        this.topTitleView.setVisibility(0);
        this.topTitleView.setText(title);
        return (T)this;
    }

    public T setTopTitleColor(int color) {
        this.topTitleView.setTextColor(color);
        return (T)this;
    }

    public T setIcon(Bitmap bitmap) {
        this.iconView.setVisibility(0);
        this.iconView.setImageBitmap(bitmap);
        return (T)this;
    }

    public T setIcon(Drawable drawable) {
        this.iconView.setVisibility(0);
        this.iconView.setImageDrawable(drawable);
        return (T)this;
    }

    public T setIcon(@DrawableRes int iconRes) {
        this.iconView.setVisibility(0);
        this.iconView.setImageResource(iconRes);
        return (T)this;
    }

    public T setIconTintColor(int iconTintColor) {
        this.iconView.setColorFilter(iconTintColor);
        return (T)this;
    }

    public T setTitleGravity(int gravity) {
        this.titleView.setGravity(gravity);
        return (T)this;
    }

    public T setMessageGravity(int gravity) {
        this.messageView.setGravity(gravity);
        return (T)this;
    }

    public T setTopColor(@ColorInt int topColor) {
        this.findView(R.id.ld_color_area).setBackgroundColor(topColor);
        return (T)this;
    }

    public T setTopColorRes(@ColorRes int topColoRes) {
        return this.setTopColor(this.color(topColoRes));
    }

    public T setInstanceStateHandler(int id2, LovelySaveStateHandler handler) {
        handler.handleDialogStateSave(id2, this);
        return (T)this;
    }

    public T setCancelable(boolean cancelable) {
        this.dialog.setCancelable(cancelable);
        return (T)this;
    }

    public T setSavedInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            boolean hasSavedStateHere;
            boolean bl = hasSavedStateHere = savedInstanceState.keySet().contains(KEY_SAVED_STATE_TOKEN) && savedInstanceState.getSerializable(KEY_SAVED_STATE_TOKEN) == this.getClass();
            if (hasSavedStateHere) {
                this.restoreState(savedInstanceState);
            }
        }
        return (T)this;
    }

    public Dialog show() {
        this.dialog.show();
        return this.dialog;
    }

    public Dialog create() {
        return this.dialog;
    }

    public void dismiss() {
        this.dialog.dismiss();
    }

    void onSaveInstanceState(Bundle outState) {
        outState.putSerializable(KEY_SAVED_STATE_TOKEN, this.getClass());
    }

    void restoreState(Bundle savedState) {
    }

    boolean isShowing() {
        return this.dialog != null && this.dialog.isShowing();
    }

    protected String string(@StringRes int res) {
        return this.dialogView.getContext().getString(res);
    }

    protected int color(@ColorRes int colorRes) {
        return ContextCompat.getColor((Context)this.getContext(), (int)colorRes);
    }

    protected Context getContext() {
        return this.dialogView.getContext();
    }

    protected <ViewClass extends View> ViewClass findView(int id2) {
        return (ViewClass)this.dialogView.findViewById(id2);
    }

    protected class ClickListenerDecorator
    implements View.OnClickListener {
        private View.OnClickListener clickListener;
        private boolean closeOnClick;

        protected ClickListenerDecorator(View.OnClickListener clickListener, boolean closeOnClick) {
            this.clickListener = clickListener;
            this.closeOnClick = closeOnClick;
        }

        public void onClick(View v) {
            if (this.clickListener != null) {
                if (this.clickListener instanceof LovelyDialogCompat.DialogOnClickListenerAdapter) {
                    LovelyDialogCompat.DialogOnClickListenerAdapter listener = (LovelyDialogCompat.DialogOnClickListenerAdapter)this.clickListener;
                    listener.onClick((DialogInterface)AbsLovelyDialog.this.dialog, v.getId());
                } else {
                    this.clickListener.onClick(v);
                }
            }
            if (this.closeOnClick) {
                AbsLovelyDialog.this.dismiss();
            }
        }
    }
}

