/*
 * Decompiled with CFR 0.152.
 */
package com.necer.utils.hutool;

import java.time.LocalDate;
import kotlin.Metadata;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bJ\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/necer/utils/hutool/LunarInfo;", "", "()V", "BASE_DAY", "", "getBASE_DAY", "()J", "BASE_YEAR", "", "LUNAR_CODE", "", "MAX_YEAR", "getMAX_YEAR", "()I", "getCode", "year", "leapDays", "y", "leapMonth", "monthDays", "m", "yearDays", "ncalendar_release"})
public final class LunarInfo {
    public static final int BASE_YEAR = 1900;
    private static final long BASE_DAY;
    private static final long[] LUNAR_CODE;
    private static final int MAX_YEAR;
    public static final LunarInfo INSTANCE;

    public final long getBASE_DAY() {
        return BASE_DAY;
    }

    public final int getMAX_YEAR() {
        return MAX_YEAR;
    }

    public final int yearDays(int y) {
        int i = 0;
        int sum = 348;
        for (i = 32768; i > 8; i >>= 1) {
            if ((this.getCode(y) & (long)i) == 0L) continue;
            ++sum;
        }
        return sum + this.leapDays(y);
    }

    public final int leapDays(int y) {
        return this.leapMonth(y) != 0 ? ((this.getCode(y) & 0x10000L) != 0L ? 30 : 29) : 0;
    }

    public final int monthDays(int y, int m) {
        return (this.getCode(y) & (long)(65536 >> m)) == 0L ? 29 : 30;
    }

    public final int leapMonth(int y) {
        return (int)(this.getCode(y) & 0xFL);
    }

    private final long getCode(int year) {
        return LUNAR_CODE[year - 1900];
    }

    private LunarInfo() {
    }

    static {
        LunarInfo lunarInfo;
        INSTANCE = lunarInfo = new LunarInfo();
        BASE_DAY = LocalDate.of(1900, 1, 31).toEpochDay();
        LUNAR_CODE = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 92821L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42416L, 83315L, 21168L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46752L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 23232L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19195L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L, 84835L, 37744L, 18936L, 18800L, 25776L, 92326L, 59984L, 27424L, 108228L, 43744L, 37600L, 53987L, 51552L, 54615L, 54432L, 55888L, 23893L, 22176L, 42704L, 21972L, 21200L, 43448L, 43344L, 46240L, 46758L, 44368L, 21920L, 43940L, 42416L, 21168L, 45683L, 26928L, 29495L, 27296L, 44368L, 84821L, 19296L, 42352L, 21732L, 53600L, 59752L, 54560L, 55968L, 92838L, 22224L, 19168L, 43476L, 41680L, 53584L, 62034L};
        MAX_YEAR = 1900 + LUNAR_CODE.length - 1;
    }
}

