/*
 * Decompiled with CFR 0.152.
 */
package com.necer.utils.hutool;

import com.necer.utils.hutool.GanZhi;
import com.necer.utils.hutool.LunarFestival;
import com.necer.utils.hutool.LunarInfo;
import com.necer.utils.hutool.SolarFestival;
import com.necer.utils.hutool.SolarTerms;
import java.time.LocalDate;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0006\u0010\u001f\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0019J\u0006\u0010\"\u001a\u00020\u0007J \u0010\"\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0019H\u0002J\b\u0010#\u001a\u0004\u0018\u00010\u0007J\u0012\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u0006\u0010$\u001a\u00020\u0007J\b\u0010%\u001a\u0004\u0018\u00010\u0007J\u0006\u0010&\u001a\u00020\rJ\b\u0010'\u001a\u0004\u0018\u00010\u0007J\b\u0010(\u001a\u0004\u0018\u00010\u0007J\u0006\u0010)\u001a\u00020\u0007J\b\u0010*\u001a\u00020\u0007H\u0016J\u0006\u0010+\u001a\u00020\u0007R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/necer/utils/hutool/ChineseDate;", "", "localDate", "Ljava/time/LocalDate;", "(Ljava/time/LocalDate;)V", "CHINESE_ZODIACS", "", "", "[Ljava/lang/String;", "DAY_NAME", "MONTH_NAME", "MONTH_NAME_TRADITIONAL", "chineseYear", "", "getChineseYear", "()I", "day", "getDay", "gregorianDay", "getGregorianDay", "gregorianMonthBase1", "getGregorianMonthBase1", "gregorianYear", "getGregorianYear", "isLeapMonth", "", "()Z", "month", "getMonth", "cyclicalm", "year", "getChineseDay", "getChineseMonth", "isTraditional", "getChineseMonthName", "getChineseZodiac", "getCyclical", "getCyclicalYMD", "getGregorianMonth", "getLunarFestivals", "getSolarFestivals", "getTerm", "toString", "toStringNormal", "ncalendar_release"})
public final class ChineseDate {
    private final String[] DAY_NAME;
    private final String[] MONTH_NAME;
    private final String[] MONTH_NAME_TRADITIONAL;
    private final String[] CHINESE_ZODIACS;
    private final int chineseYear;
    private final int month;
    private final boolean isLeapMonth;
    private final int day;
    private final int gregorianYear;
    private final int gregorianMonthBase1;
    private final int gregorianDay;

    public final int getChineseYear() {
        return this.chineseYear;
    }

    public final int getMonth() {
        return this.month;
    }

    public final boolean isLeapMonth() {
        return this.isLeapMonth;
    }

    public final int getDay() {
        return this.day;
    }

    public final int getGregorianYear() {
        return this.gregorianYear;
    }

    public final int getGregorianMonthBase1() {
        return this.gregorianMonthBase1;
    }

    public final int getGregorianDay() {
        return this.gregorianDay;
    }

    public final int getGregorianMonth() {
        return this.gregorianMonthBase1 - 1;
    }

    @NotNull
    public final String getChineseMonth() {
        return this.getChineseMonth(false);
    }

    @NotNull
    public final String getChineseMonthName() {
        return this.getChineseMonth(true);
    }

    @NotNull
    public final String getChineseMonth(boolean isTraditional) {
        return this.getChineseMonthName(this.isLeapMonth, this.isLeapMonth ? this.month - 1 : this.month, isTraditional);
    }

    @NotNull
    public final String getChineseDay() {
        String string2;
        int n;
        String[] chineseTen = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345"};
        int n2 = n = this.day % 10 == 0 ? 9 : this.day % 10 - 1;
        if (this.day > 30) {
            string2 = "";
        } else {
            switch (this.day) {
                case 10: {
                    string2 = "\u521d\u5341";
                    break;
                }
                case 20: {
                    string2 = "\u4e8c\u5341";
                    break;
                }
                case 30: {
                    string2 = "\u4e09\u5341";
                    break;
                }
                default: {
                    string2 = chineseTen[this.day / 10] + this.DAY_NAME[n];
                }
            }
        }
        return string2;
    }

    @Nullable
    public final String getLunarFestivals() {
        return LunarFestival.INSTANCE.getFestivals(this.chineseYear, this.month, this.day);
    }

    @Nullable
    public final String getSolarFestivals() {
        return SolarFestival.INSTANCE.getFestivals(this.gregorianMonthBase1, this.gregorianDay);
    }

    @Nullable
    public final String getChineseZodiac() {
        return this.getChineseZodiac(this.chineseYear);
    }

    @NotNull
    public final String getCyclical() {
        return GanZhi.INSTANCE.getGanzhiOfYear(this.chineseYear);
    }

    @Nullable
    public final String getCyclicalYMD() {
        return this.gregorianYear >= 1900 && this.gregorianMonthBase1 > 0 && this.gregorianDay > 0 ? this.cyclicalm(this.gregorianYear, this.gregorianMonthBase1, this.gregorianDay) : null;
    }

    @NotNull
    public final String getTerm() {
        return SolarTerms.INSTANCE.getTerm(this.gregorianYear, this.gregorianMonthBase1, this.gregorianDay);
    }

    @NotNull
    public final String toStringNormal() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%04d-%02d-%02d";
        Object[] objectArray = new Object[]{this.chineseYear, this.isLeapMonth ? this.month - 1 : this.month, this.day};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        return string3;
    }

    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%s%s\u5e74 %s%s";
        Object[] objectArray = new Object[]{this.getCyclical(), this.getChineseZodiac(), this.getChineseMonthName(), this.getChineseDay()};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        return string3;
    }

    private final String cyclicalm(int year, int month, int day) {
        return GanZhi.INSTANCE.getGanzhiOfYear(this.chineseYear) + "\u5e74" + GanZhi.INSTANCE.getGanzhiOfMonth(year, month, day) + "\u6708" + GanZhi.INSTANCE.getGanzhiOfDay(year, month, day) + "\u65e5";
    }

    private final String getChineseMonthName(boolean isLeapMonth, int month, boolean isTraditional) {
        return (isLeapMonth ? "\u95f0" : "") + (isTraditional ? this.MONTH_NAME_TRADITIONAL : this.MONTH_NAME)[month - 1] + "\u6708";
    }

    private final String getChineseZodiac(int year) {
        return year < 1900 ? null : this.CHINESE_ZODIACS[(year - 1900) % this.CHINESE_ZODIACS.length];
    }

    public ChineseDate(@NotNull LocalDate localDate) {
        Intrinsics.checkParameterIsNotNull((Object)localDate, (String)"localDate");
        this.DAY_NAME = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};
        this.MONTH_NAME = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
        this.MONTH_NAME_TRADITIONAL = new String[]{"\u6b63", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5bd2", "\u51ac", "\u814a"};
        this.CHINESE_ZODIACS = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
        this.gregorianYear = localDate.getYear();
        this.gregorianMonthBase1 = localDate.getMonthValue();
        this.gregorianDay = localDate.getDayOfMonth();
        int offset = (int)(localDate.toEpochDay() - LunarInfo.INSTANCE.getBASE_DAY());
        int daysOfYear = 0;
        int iYear = 0;
        for (iYear = 1900; iYear <= LunarInfo.INSTANCE.getMAX_YEAR() && offset >= (daysOfYear = LunarInfo.INSTANCE.yearDays(iYear)); offset -= daysOfYear, ++iYear) {
        }
        this.chineseYear = iYear;
        int leapMonth = LunarInfo.INSTANCE.leapMonth(iYear);
        int month = 0;
        int daysOfMonth = 0;
        boolean hasLeapMonth = false;
        for (month = 1; month < 13; ++month) {
            if (leapMonth > 0 && month == leapMonth + 1) {
                daysOfMonth = LunarInfo.INSTANCE.leapDays(this.chineseYear);
                hasLeapMonth = true;
            } else {
                daysOfMonth = LunarInfo.INSTANCE.monthDays(this.chineseYear, hasLeapMonth ? month - 1 : month);
            }
            if (offset < daysOfMonth) break;
            offset -= daysOfMonth;
        }
        boolean bl = this.isLeapMonth = leapMonth > 0 && month == leapMonth + 1;
        if (hasLeapMonth && !this.isLeapMonth) {
            --month;
        }
        this.month = month;
        this.day = offset + 1;
    }
}

