/*
 * Decompiled with CFR 0.152.
 */
package com.necer.utils;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/necer/utils/NDateUtil;", "", "()V", "getIntervalMonths", "", "startDate", "Ljava/time/LocalDate;", "endDate", "getIntervalWeek", "date1", "date2", "weekType", "getMonthDate", "", "localDate", "isAllMonthSixLine", "", "getWeekDate", "isEqualsMonth", "isLastMonth", "isNextMonth", "isToday", "date", "ncalendar_release"})
public final class NDateUtil {
    public static final NDateUtil INSTANCE;

    @NotNull
    public final List<LocalDate> getMonthDate(@NotNull LocalDate localDate, int weekType, boolean isAllMonthSixLine) {
        Intrinsics.checkParameterIsNotNull((Object)localDate, (String)"localDate");
        DayOfWeek firstDayOfWeek = weekType == 301 ? DayOfWeek.MONDAY : DayOfWeek.SUNDAY;
        LocalDate firstDayOfMonth = localDate.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastDayOfMonth = localDate.with(TemporalAdjusters.lastDayOfMonth());
        LocalDate localDate2 = firstDayOfMonth;
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate2, (String)"firstDayOfMonth");
        DayOfWeek dayOfWeek = localDate2.getDayOfWeek();
        Intrinsics.checkExpressionValueIsNotNull((Object)dayOfWeek, (String)"firstDayOfMonth.dayOfWeek");
        int n = dayOfWeek.getValue() - firstDayOfWeek.getValue();
        int n2 = firstDayOfWeek.getValue();
        DayOfWeek dayOfWeek2 = firstDayOfMonth.getDayOfWeek();
        Intrinsics.checkExpressionValueIsNotNull((Object)dayOfWeek2, (String)"firstDayOfMonth.dayOfWeek");
        LocalDate startDate = firstDayOfMonth.minusDays(n + (n2 > dayOfWeek2.getValue() ? 7 : 0));
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        LocalDate currentDay = startDate;
        while (dates.size() < 35) {
            dates.add(currentDay);
            currentDay = currentDay.plusDays(1L);
        }
        if (isAllMonthSixLine || ((LocalDate)dates.get(dates.size() - 1)).isBefore(lastDayOfMonth)) {
            while (dates.size() < 42) {
                dates.add(currentDay);
                currentDay = currentDay.plusDays(1L);
            }
        }
        return dates;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocalDate> getWeekDate(@NotNull LocalDate localDate, int weekType) {
        Intrinsics.checkParameterIsNotNull((Object)localDate, (String)"localDate");
        DayOfWeek firstDayOfWeek = weekType == 301 ? DayOfWeek.MONDAY : DayOfWeek.SUNDAY;
        LocalDate firstDayOfWeekDate = localDate.with(TemporalAdjusters.previousOrSame(firstDayOfWeek));
        ArrayList<LocalDate> weekDates = new ArrayList<LocalDate>();
        int n = 0;
        int n2 = 6;
        while (n <= n2) {
            void dayOfWeek;
            weekDates.add(firstDayOfWeekDate.plusDays((long)dayOfWeek));
            ++dayOfWeek;
        }
        return weekDates;
    }

    public final int getIntervalMonths(@NotNull LocalDate startDate, @NotNull LocalDate endDate) {
        Intrinsics.checkParameterIsNotNull((Object)startDate, (String)"startDate");
        Intrinsics.checkParameterIsNotNull((Object)endDate, (String)"endDate");
        if (startDate.isAfter(endDate)) {
            return -this.getIntervalMonths(endDate, startDate);
        }
        LocalDate date1 = LocalDate.of(startDate.getYear(), startDate.getMonth(), 1);
        LocalDate date2 = LocalDate.of(endDate.getYear(), endDate.getMonth(), 1);
        long months = ChronoUnit.MONTHS.between(date1, date2);
        return (int)months;
    }

    public final int getIntervalWeek(@NotNull LocalDate date1, @NotNull LocalDate date2, int weekType) {
        Intrinsics.checkParameterIsNotNull((Object)date1, (String)"date1");
        Intrinsics.checkParameterIsNotNull((Object)date2, (String)"date2");
        DayOfWeek firstDayOfWeek = weekType == 301 ? DayOfWeek.MONDAY : DayOfWeek.SUNDAY;
        LocalDate adjustedDate1 = date1.with(TemporalAdjusters.previousOrSame(firstDayOfWeek));
        LocalDate adjustedDate2 = date2.with(TemporalAdjusters.previousOrSame(firstDayOfWeek));
        long daysBetween = ChronoUnit.DAYS.between(adjustedDate1, adjustedDate2);
        return (int)(daysBetween / (long)7);
    }

    public final boolean isEqualsMonth(@NotNull LocalDate date1, @NotNull LocalDate date2) {
        Intrinsics.checkParameterIsNotNull((Object)date1, (String)"date1");
        Intrinsics.checkParameterIsNotNull((Object)date2, (String)"date2");
        return date1.getYear() == date2.getYear() && date1.getMonthValue() == date2.getMonthValue();
    }

    public final boolean isToday(@Nullable LocalDate date) {
        return LocalDate.now().isEqual(date);
    }

    public final boolean isLastMonth(@NotNull LocalDate date1, @NotNull LocalDate date2) {
        Intrinsics.checkParameterIsNotNull((Object)date1, (String)"date1");
        Intrinsics.checkParameterIsNotNull((Object)date2, (String)"date2");
        LocalDate date = date2.plusMonths(-1L);
        int n = date1.getMonthValue();
        LocalDate localDate = date;
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"date");
        return n == localDate.getMonthValue();
    }

    public final boolean isNextMonth(@NotNull LocalDate date1, @NotNull LocalDate date2) {
        Intrinsics.checkParameterIsNotNull((Object)date1, (String)"date1");
        Intrinsics.checkParameterIsNotNull((Object)date2, (String)"date2");
        LocalDate date = date2.plusMonths(1L);
        int n = date1.getMonthValue();
        LocalDate localDate = date;
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"date");
        return n == localDate.getMonthValue();
    }

    private NDateUtil() {
    }

    static {
        NDateUtil nDateUtil;
        INSTANCE = nDateUtil = new NDateUtil();
    }
}

