/*
 * Decompiled with CFR 0.152.
 */
package com.necer.painter;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import androidx.core.content.ContextCompat;
import com.necer.R;
import com.necer.calendar.ICalendar;
import com.necer.painter.CalendarPainter;
import com.necer.utils.NAttrs;
import com.necer.utils.hutool.ChineseDate;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170#J.\u0010$\u001a\u00020!2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010\f2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u0015H\u0002JL\u0010+\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00112\b\u0010-\u001a\u0004\u0018\u00010\f2\b\u0010.\u001a\u0004\u0018\u00010\f2\u0006\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0015H\u0002J4\u00101\u001a\u00020!2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010,\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0015H\u0002J8\u00103\u001a\u00020!2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u00104\u001a\u0004\u0018\u00010\u00112\b\u0010'\u001a\u0004\u0018\u00010\f2\u0006\u0010*\u001a\u00020\u0015H\u0002J6\u00105\u001a\u00020!2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u00104\u001a\u0004\u0018\u00010\u00112\u0006\u00102\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0015H\u0002J.\u00106\u001a\u00020!2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u00152\b\u0010,\u001a\u0004\u0018\u00010\u0011H\u0002J\"\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u00152\b\u0010'\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010;\u001a\u00020<2\u0006\u00109\u001a\u00020=2\u0006\u0010:\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u00020=2\u0006\u0010:\u001a\u00020=H\u0002J.\u0010?\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00112\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110#H\u0016J \u0010A\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u0011H\u0016J.\u0010B\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00112\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110#H\u0016J.\u0010C\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00112\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00110#H\u0016J&\u0010D\u001a\u00020!2\u000e\u0010E\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170#2\u000e\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170#J\u0016\u0010G\u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170#J\u001e\u0010H\u001a\u00020!2\u0016\u0010I\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00150JJ\u001e\u0010K\u001a\u00020!2\u0016\u0010L\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00170JJ\u001a\u0010M\u001a\u00020!2\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170JR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/necer/painter/InnerPainter;", "Lcom/necer/painter/CalendarPainter;", "mContext", "Landroid/content/Context;", "iCalendar", "Lcom/necer/calendar/ICalendar;", "(Landroid/content/Context;Lcom/necer/calendar/ICalendar;)V", "getICalendar", "()Lcom/necer/calendar/ICalendar;", "mDateFormatter", "Ljava/time/format/DateTimeFormatter;", "mDefaultCheckedBackground", "Landroid/graphics/drawable/Drawable;", "mDefaultCheckedPoint", "mDefaultUnCheckedPoint", "mHolidayList", "", "Ljava/time/LocalDate;", "mPointList", "mReplaceLunarColorMap", "", "", "mReplaceLunarStrMap", "", "mStretchStrMap", "mTextPaint", "Landroid/graphics/Paint;", "mTodayCheckedBackground", "mTodayCheckedPoint", "mTodayUnCheckedPoint", "mWorkdayList", "noAlphaColor", "addPointList", "", "list", "", "drawCheckedBackground", "canvas", "Landroid/graphics/Canvas;", "drawable", "rectF", "Landroid/graphics/RectF;", "alphaColor", "drawHolidayWorkday", "localDate", "holidayDrawable", "workdayDrawable", "holidayTextColor", "workdayTextColor", "drawLunar", "color", "drawPoint", "date", "drawSolar", "drawStretchText", "getDrawableBounds", "Landroid/graphics/Rect;", "centerX", "centerY", "getHolidayWorkdayLocation", "", "", "getTextBaseLineY", "onDrawCurrentMonthOrWeek", "checkedDateList", "onDrawDisableDate", "onDrawLastOrNextMonth", "onDrawToday", "setLegalHolidayList", "holidayList", "workdayList", "setPointList", "setReplaceLunarColorMap", "replaceLunarColorMap", "", "setReplaceLunarStrMap", "replaceLunarStrMap", "setStretchStrMap", "stretchStrMap", "ncalendar_release"})
public final class InnerPainter
implements CalendarPainter {
    private final Paint mTextPaint;
    private final int noAlphaColor = 255;
    private final List<LocalDate> mHolidayList;
    private final List<LocalDate> mWorkdayList;
    private final List<LocalDate> mPointList;
    private final Map<LocalDate, String> mReplaceLunarStrMap;
    private final Map<LocalDate, Integer> mReplaceLunarColorMap;
    private final Map<LocalDate, String> mStretchStrMap;
    private final Drawable mDefaultCheckedBackground;
    private final Drawable mTodayCheckedBackground;
    private final Drawable mDefaultCheckedPoint;
    private final Drawable mDefaultUnCheckedPoint;
    private final Drawable mTodayCheckedPoint;
    private final Drawable mTodayUnCheckedPoint;
    private final DateTimeFormatter mDateFormatter;
    private final Context mContext;
    @NotNull
    private final ICalendar iCalendar;

    @Override
    public void onDrawToday(@NotNull Canvas canvas, @NotNull RectF rectF, @NotNull LocalDate localDate, @NotNull List<LocalDate> checkedDateList) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"rectF");
        Intrinsics.checkParameterIsNotNull((Object)localDate, (String)"localDate");
        Intrinsics.checkParameterIsNotNull(checkedDateList, (String)"checkedDateList");
        if (checkedDateList.contains(localDate)) {
            this.drawCheckedBackground(canvas, this.mTodayCheckedBackground, rectF, this.noAlphaColor);
            this.drawSolar(canvas, rectF, localDate, NAttrs.INSTANCE.getTodayCheckedSolarTextColor(), this.noAlphaColor);
            this.drawLunar(canvas, rectF, localDate, NAttrs.INSTANCE.getTodayCheckedLunarTextColor(), this.noAlphaColor);
            this.drawPoint(canvas, rectF, localDate, this.mTodayCheckedPoint, this.noAlphaColor);
            this.drawHolidayWorkday(canvas, rectF, localDate, NAttrs.INSTANCE.getTodayCheckedHoliday(), NAttrs.INSTANCE.getTodayCheckedWorkday(), NAttrs.INSTANCE.getTodayCheckedHolidayTextColor(), NAttrs.INSTANCE.getTodayCheckedWorkdayTextColor(), this.noAlphaColor);
        } else {
            this.drawSolar(canvas, rectF, localDate, NAttrs.INSTANCE.getTodayUnCheckedSolarTextColor(), this.noAlphaColor);
            this.drawLunar(canvas, rectF, localDate, NAttrs.INSTANCE.getTodayUnCheckedLunarTextColor(), this.noAlphaColor);
            this.drawPoint(canvas, rectF, localDate, this.mTodayUnCheckedPoint, this.noAlphaColor);
            this.drawHolidayWorkday(canvas, rectF, localDate, NAttrs.INSTANCE.getTodayUnCheckedHoliday(), NAttrs.INSTANCE.getTodayUnCheckedWorkday(), NAttrs.INSTANCE.getTodayUnCheckedHolidayTextColor(), NAttrs.INSTANCE.getTodayUnCheckedWorkdayTextColor(), this.noAlphaColor);
        }
        this.drawStretchText(canvas, rectF, this.noAlphaColor, localDate);
    }

    @Override
    public void onDrawCurrentMonthOrWeek(@NotNull Canvas canvas, @NotNull RectF rectF, @NotNull LocalDate localDate, @NotNull List<LocalDate> checkedDateList) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"rectF");
        Intrinsics.checkParameterIsNotNull((Object)localDate, (String)"localDate");
        Intrinsics.checkParameterIsNotNull(checkedDateList, (String)"checkedDateList");
        if (checkedDateList.contains(localDate)) {
            this.drawCheckedBackground(canvas, this.mDefaultCheckedBackground, rectF, this.noAlphaColor);
            this.drawSolar(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultCheckedSolarTextColor(), this.noAlphaColor);
            this.drawLunar(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultCheckedLunarTextColor(), this.noAlphaColor);
            this.drawPoint(canvas, rectF, localDate, this.mDefaultCheckedPoint, this.noAlphaColor);
            this.drawHolidayWorkday(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultCheckedHoliday(), NAttrs.INSTANCE.getDefaultCheckedWorkday(), NAttrs.INSTANCE.getDefaultCheckedHolidayTextColor(), NAttrs.INSTANCE.getDefaultCheckedWorkdayTextColor(), this.noAlphaColor);
        } else {
            this.drawSolar(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultUnCheckedSolarTextColor(), this.noAlphaColor);
            this.drawLunar(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultUnCheckedLunarTextColor(), this.noAlphaColor);
            this.drawPoint(canvas, rectF, localDate, this.mDefaultUnCheckedPoint, this.noAlphaColor);
            this.drawHolidayWorkday(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultUnCheckedHoliday(), NAttrs.INSTANCE.getDefaultUnCheckedWorkday(), NAttrs.INSTANCE.getDefaultUnCheckedHolidayTextColor(), NAttrs.INSTANCE.getDefaultUnCheckedWorkdayTextColor(), this.noAlphaColor);
        }
        this.drawStretchText(canvas, rectF, this.noAlphaColor, localDate);
    }

    @Override
    public void onDrawLastOrNextMonth(@NotNull Canvas canvas, @NotNull RectF rectF, @NotNull LocalDate localDate, @NotNull List<LocalDate> checkedDateList) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"rectF");
        Intrinsics.checkParameterIsNotNull((Object)localDate, (String)"localDate");
        Intrinsics.checkParameterIsNotNull(checkedDateList, (String)"checkedDateList");
        if (checkedDateList.contains(localDate)) {
            this.drawCheckedBackground(canvas, this.mDefaultCheckedBackground, rectF, NAttrs.INSTANCE.getLastNextMothAlphaColor());
            this.drawSolar(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultCheckedSolarTextColor(), NAttrs.INSTANCE.getLastNextMothAlphaColor());
            this.drawLunar(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultCheckedLunarTextColor(), NAttrs.INSTANCE.getLastNextMothAlphaColor());
            this.drawPoint(canvas, rectF, localDate, this.mDefaultCheckedPoint, NAttrs.INSTANCE.getLastNextMothAlphaColor());
            this.drawHolidayWorkday(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultCheckedHoliday(), NAttrs.INSTANCE.getDefaultCheckedWorkday(), NAttrs.INSTANCE.getDefaultCheckedHolidayTextColor(), NAttrs.INSTANCE.getDefaultCheckedWorkdayTextColor(), NAttrs.INSTANCE.getLastNextMothAlphaColor());
        } else {
            this.drawSolar(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultUnCheckedSolarTextColor(), NAttrs.INSTANCE.getLastNextMothAlphaColor());
            this.drawLunar(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultUnCheckedLunarTextColor(), NAttrs.INSTANCE.getLastNextMothAlphaColor());
            this.drawPoint(canvas, rectF, localDate, this.mDefaultUnCheckedPoint, NAttrs.INSTANCE.getLastNextMothAlphaColor());
            this.drawHolidayWorkday(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultUnCheckedHoliday(), NAttrs.INSTANCE.getDefaultUnCheckedWorkday(), NAttrs.INSTANCE.getDefaultUnCheckedHolidayTextColor(), NAttrs.INSTANCE.getDefaultUnCheckedWorkdayTextColor(), NAttrs.INSTANCE.getLastNextMothAlphaColor());
        }
        this.drawStretchText(canvas, rectF, NAttrs.INSTANCE.getLastNextMothAlphaColor(), localDate);
    }

    @Override
    public void onDrawDisableDate(@NotNull Canvas canvas, @NotNull RectF rectF, @NotNull LocalDate localDate) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"rectF");
        Intrinsics.checkParameterIsNotNull((Object)localDate, (String)"localDate");
        this.drawSolar(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultUnCheckedSolarTextColor(), NAttrs.INSTANCE.getDisabledAlphaColor());
        this.drawLunar(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultUnCheckedLunarTextColor(), NAttrs.INSTANCE.getDisabledAlphaColor());
        this.drawPoint(canvas, rectF, localDate, this.mDefaultUnCheckedPoint, NAttrs.INSTANCE.getDisabledAlphaColor());
        this.drawHolidayWorkday(canvas, rectF, localDate, NAttrs.INSTANCE.getDefaultUnCheckedHoliday(), NAttrs.INSTANCE.getDefaultUnCheckedWorkday(), NAttrs.INSTANCE.getDefaultUnCheckedHolidayTextColor(), NAttrs.INSTANCE.getDefaultUnCheckedWorkdayTextColor(), NAttrs.INSTANCE.getDisabledAlphaColor());
        this.drawStretchText(canvas, rectF, NAttrs.INSTANCE.getDisabledAlphaColor(), localDate);
    }

    private final void drawCheckedBackground(Canvas canvas, Drawable drawable, RectF rectF, int alphaColor) {
        RectF rectF2 = rectF;
        if (rectF2 == null) {
            Intrinsics.throwNpe();
        }
        Rect drawableBounds = this.getDrawableBounds((int)rectF2.centerX(), (int)rectF.centerY(), drawable);
        Drawable drawable2 = drawable;
        if (drawable2 == null) {
            Intrinsics.throwNpe();
        }
        drawable2.setBounds(drawableBounds);
        drawable.setAlpha(alphaColor);
        Canvas canvas2 = canvas;
        if (canvas2 == null) {
            Intrinsics.throwNpe();
        }
        drawable.draw(canvas2);
    }

    private final void drawSolar(Canvas canvas, RectF rectF, LocalDate date, int color, int alphaColor) {
        this.mTextPaint.setColor(color);
        this.mTextPaint.setAlpha(alphaColor);
        this.mTextPaint.setTextSize(NAttrs.INSTANCE.getSolarTextSize());
        this.mTextPaint.setFakeBoldText(NAttrs.INSTANCE.getSolarTextBold());
        Canvas canvas2 = canvas;
        if (canvas2 == null) {
            Intrinsics.throwNpe();
        }
        StringBuilder stringBuilder = new StringBuilder();
        LocalDate localDate = date;
        if (localDate == null) {
            Intrinsics.throwNpe();
        }
        String string = stringBuilder.append(String.valueOf(localDate.getDayOfMonth())).append("").toString();
        RectF rectF2 = rectF;
        if (rectF2 == null) {
            Intrinsics.throwNpe();
        }
        canvas2.drawText(string, rectF2.centerX(), NAttrs.INSTANCE.getShowLunar() ? rectF.centerY() : this.getTextBaseLineY(rectF.centerY()), this.mTextPaint);
    }

    private final void drawLunar(Canvas canvas, RectF rectF, LocalDate localDate, int color, int alphaColor) {
        if (NAttrs.INSTANCE.getShowLunar()) {
            Integer replaceColor;
            String string;
            ChineseDate chineseDate = new ChineseDate(localDate);
            String lunarString = null;
            String replaceString = this.mReplaceLunarStrMap.get(localDate);
            if (!TextUtils.isEmpty((CharSequence)replaceString)) {
                string = replaceString;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            } else if (!TextUtils.isEmpty((CharSequence)chineseDate.getLunarFestivals())) {
                string = chineseDate.getLunarFestivals();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            } else if (!TextUtils.isEmpty((CharSequence)chineseDate.getTerm())) {
                string = chineseDate.getTerm();
            } else if (!TextUtils.isEmpty((CharSequence)chineseDate.getSolarFestivals())) {
                string = chineseDate.getSolarFestivals();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                String chineseText = chineseDate.getChineseDay();
                if (Intrinsics.areEqual((Object)chineseText, (Object)"\u521d\u4e00")) {
                    chineseText = chineseDate.getChineseMonthName();
                }
                string = chineseText;
            }
            lunarString = string;
            Integer n = replaceColor = this.mReplaceLunarColorMap.get(localDate);
            this.mTextPaint.setColor(n != null ? n : color);
            this.mTextPaint.setTextSize(NAttrs.INSTANCE.getLunarTextSize());
            this.mTextPaint.setAlpha(alphaColor);
            this.mTextPaint.setFakeBoldText(NAttrs.INSTANCE.getLunarTextBold());
            Canvas canvas2 = canvas;
            if (canvas2 == null) {
                Intrinsics.throwNpe();
            }
            RectF rectF2 = rectF;
            if (rectF2 == null) {
                Intrinsics.throwNpe();
            }
            canvas2.drawText(lunarString, rectF2.centerX(), rectF.centerY() + NAttrs.INSTANCE.getLunarDistance(), this.mTextPaint);
        }
    }

    private final void drawPoint(Canvas canvas, RectF rectF, LocalDate date, Drawable drawable, int alphaColor) {
        if (CollectionsKt.contains((Iterable)this.mPointList, (Object)date)) {
            float f;
            if (NAttrs.INSTANCE.getPointLocation() == 201) {
                RectF rectF2 = rectF;
                if (rectF2 == null) {
                    Intrinsics.throwNpe();
                }
                f = rectF2.centerY() + NAttrs.INSTANCE.getPointDistance();
            } else {
                RectF rectF3 = rectF;
                if (rectF3 == null) {
                    Intrinsics.throwNpe();
                }
                f = rectF3.centerY() - NAttrs.INSTANCE.getPointDistance();
            }
            float centerY = f;
            Rect drawableBounds = this.getDrawableBounds((int)rectF.centerX(), (int)centerY, drawable);
            Drawable drawable2 = drawable;
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            drawable2.setBounds(drawableBounds);
            drawable.setAlpha(alphaColor);
            Canvas canvas2 = canvas;
            if (canvas2 == null) {
                Intrinsics.throwNpe();
            }
            drawable.draw(canvas2);
        }
    }

    private final void drawHolidayWorkday(Canvas canvas, RectF rectF, LocalDate localDate, Drawable holidayDrawable, Drawable workdayDrawable, int holidayTextColor, int workdayTextColor, int alphaColor) {
        if (NAttrs.INSTANCE.getShowHolidayWorkday()) {
            int[] holidayLocation = this.getHolidayWorkdayLocation(rectF.centerX(), rectF.centerY());
            if (this.mHolidayList.contains(localDate)) {
                if (holidayDrawable == null) {
                    String string2;
                    this.mTextPaint.setTextSize(NAttrs.INSTANCE.getHolidayWorkdayTextSize());
                    this.mTextPaint.setColor(holidayTextColor);
                    this.mTextPaint.setAlpha(alphaColor);
                    if (TextUtils.isEmpty((CharSequence)NAttrs.INSTANCE.getHolidayText())) {
                        string2 = this.mContext.getString(R.string.N_holidayText);
                    } else {
                        string2 = NAttrs.INSTANCE.getHolidayText();
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                    }
                    canvas.drawText(string2, (float)holidayLocation[0], this.getTextBaseLineY(holidayLocation[1]), this.mTextPaint);
                } else {
                    Rect drawableBounds = this.getDrawableBounds(holidayLocation[0], holidayLocation[1], holidayDrawable);
                    holidayDrawable.setBounds(drawableBounds);
                    holidayDrawable.setAlpha(alphaColor);
                    holidayDrawable.draw(canvas);
                }
            } else if (this.mWorkdayList.contains(localDate)) {
                if (workdayDrawable == null) {
                    String string3;
                    this.mTextPaint.setTextSize(NAttrs.INSTANCE.getHolidayWorkdayTextSize());
                    this.mTextPaint.setColor(workdayTextColor);
                    this.mTextPaint.setAlpha(alphaColor);
                    this.mTextPaint.setFakeBoldText(NAttrs.INSTANCE.getHolidayWorkdayTextBold());
                    if (TextUtils.isEmpty((CharSequence)NAttrs.INSTANCE.getWorkdayText())) {
                        string3 = this.mContext.getString(R.string.N_workdayText);
                    } else {
                        string3 = NAttrs.INSTANCE.getWorkdayText();
                        if (string3 == null) {
                            Intrinsics.throwNpe();
                        }
                    }
                    canvas.drawText(string3, (float)holidayLocation[0], this.getTextBaseLineY(holidayLocation[1]), this.mTextPaint);
                } else {
                    Rect drawableBounds = this.getDrawableBounds(holidayLocation[0], holidayLocation[1], workdayDrawable);
                    workdayDrawable.setBounds(drawableBounds);
                    workdayDrawable.setAlpha(alphaColor);
                    workdayDrawable.draw(canvas);
                }
            }
        }
    }

    private final void drawStretchText(Canvas canvas, RectF rectF, int alphaColor, LocalDate localDate) {
        float v;
        RectF rectF2 = rectF;
        if (rectF2 == null) {
            Intrinsics.throwNpe();
        }
        if ((v = rectF2.centerY() + NAttrs.INSTANCE.getStretchTextDistance()) <= rectF.bottom) {
            Map<LocalDate, String> map = this.mStretchStrMap;
            boolean bl = false;
            String stretchText = map.get(localDate);
            if (!TextUtils.isEmpty((CharSequence)stretchText)) {
                this.mTextPaint.setTextSize(NAttrs.INSTANCE.getStretchTextSize());
                this.mTextPaint.setColor(NAttrs.INSTANCE.getStretchTextColor());
                this.mTextPaint.setAlpha(alphaColor);
                this.mTextPaint.setFakeBoldText(NAttrs.INSTANCE.getStretchTextBold());
                Canvas canvas2 = canvas;
                if (canvas2 == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = stretchText;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                canvas2.drawText(string2, rectF.centerX(), rectF.centerY() + NAttrs.INSTANCE.getStretchTextDistance(), this.mTextPaint);
            }
        }
    }

    private final float getTextBaseLineY(float centerY) {
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        return centerY - (fontMetrics.bottom - fontMetrics.top) / (float)2 - fontMetrics.top;
    }

    private final int[] getHolidayWorkdayLocation(float centerX, float centerY) {
        int[] location = new int[2];
        switch (NAttrs.INSTANCE.getHolidayWorkdayLocation()) {
            case 401: {
                location[0] = (int)(centerX - NAttrs.INSTANCE.getHolidayWorkdayDistance());
                location[1] = (int)(centerY - NAttrs.INSTANCE.getHolidayWorkdayDistance() / (float)2);
                break;
            }
            case 402: {
                location[0] = (int)(centerX + NAttrs.INSTANCE.getHolidayWorkdayDistance());
                location[1] = (int)(centerY + NAttrs.INSTANCE.getHolidayWorkdayDistance() / (float)2);
                break;
            }
            case 403: {
                location[0] = (int)(centerX - NAttrs.INSTANCE.getHolidayWorkdayDistance());
                location[1] = (int)(centerY + NAttrs.INSTANCE.getHolidayWorkdayDistance() / (float)2);
                break;
            }
            case 400: {
                location[0] = (int)(centerX + NAttrs.INSTANCE.getHolidayWorkdayDistance());
                location[1] = (int)(centerY - NAttrs.INSTANCE.getHolidayWorkdayDistance() / (float)2);
                break;
            }
            default: {
                location[0] = (int)(centerX + NAttrs.INSTANCE.getHolidayWorkdayDistance());
                location[1] = (int)(centerY - NAttrs.INSTANCE.getHolidayWorkdayDistance() / (float)2);
            }
        }
        return location;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPointList(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.mPointList.clear();
        int n = 0;
        int n2 = ((Collection)list).size();
        while (n < n2) {
            LocalDate localDate;
            void i;
            LocalDate localDate2 = null;
            try {
                localDate = LocalDate.parse(list.get((int)i), this.mDateFormatter);
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException("setPointList\u7684\u53c2\u6570\u9700\u8981 yyyy-MM-dd \u683c\u5f0f\u7684\u65e5\u671f");
            }
            LocalDate localDate3 = localDate2 = localDate;
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate3, (String)"localDate");
            this.mPointList.add(localDate3);
            ++i;
        }
        this.iCalendar.notifyCalendar();
    }

    /*
     * WARNING - void declaration
     */
    public final void addPointList(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        int n = 0;
        int n2 = ((Collection)list).size();
        while (n < n2) {
            LocalDate localDate;
            void i;
            LocalDate localDate2 = null;
            try {
                localDate = LocalDate.parse(list.get((int)i), this.mDateFormatter);
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException("setPointList\u7684\u53c2\u6570\u9700\u8981 yyyy-MM-dd \u683c\u5f0f\u7684\u65e5\u671f");
            }
            localDate2 = localDate;
            if (!this.mPointList.contains(localDate2)) {
                LocalDate localDate3 = localDate2;
                Intrinsics.checkExpressionValueIsNotNull((Object)localDate3, (String)"localDate");
                this.mPointList.add(localDate3);
            }
            ++i;
        }
        this.iCalendar.notifyCalendar();
    }

    public final void setReplaceLunarStrMap(@NotNull Map<String, String> replaceLunarStrMap) {
        Intrinsics.checkParameterIsNotNull(replaceLunarStrMap, (String)"replaceLunarStrMap");
        this.mReplaceLunarStrMap.clear();
        for (String key : replaceLunarStrMap.keySet()) {
            LocalDate localDate;
            try {
                Intrinsics.checkExpressionValueIsNotNull((Object)LocalDate.parse(key, this.mDateFormatter), (String)"LocalDate.parse(key,mDateFormatter)");
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException("setReplaceLunarStrMap\u7684\u53c2\u6570\u9700\u8981 yyyy-MM-dd \u683c\u5f0f\u7684\u65e5\u671f");
            }
            LocalDate localDate2 = localDate;
            this.mReplaceLunarStrMap.put(localDate2, replaceLunarStrMap.get(key));
        }
        this.iCalendar.notifyCalendar();
    }

    public final void setReplaceLunarColorMap(@NotNull Map<String, Integer> replaceLunarColorMap) {
        Intrinsics.checkParameterIsNotNull(replaceLunarColorMap, (String)"replaceLunarColorMap");
        this.mReplaceLunarColorMap.clear();
        for (String key : replaceLunarColorMap.keySet()) {
            LocalDate localDate;
            try {
                Intrinsics.checkExpressionValueIsNotNull((Object)LocalDate.parse(key, this.mDateFormatter), (String)"LocalDate.parse(key,mDateFormatter)");
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException("setReplaceLunarColorMap\u7684\u53c2\u6570\u9700\u8981 yyyy-MM-dd \u683c\u5f0f\u7684\u65e5\u671f");
            }
            LocalDate localDate2 = localDate;
            this.mReplaceLunarColorMap.put(localDate2, replaceLunarColorMap.get(key));
        }
        this.iCalendar.notifyCalendar();
    }

    public final void setLegalHolidayList(@NotNull List<String> holidayList, @NotNull List<String> workdayList) {
        LocalDate localDate;
        int i;
        Intrinsics.checkParameterIsNotNull(holidayList, (String)"holidayList");
        Intrinsics.checkParameterIsNotNull(workdayList, (String)"workdayList");
        this.mHolidayList.clear();
        this.mWorkdayList.clear();
        int n = 0;
        int n2 = ((Collection)holidayList).size();
        while (n < n2) {
            try {
                Intrinsics.checkExpressionValueIsNotNull((Object)LocalDate.parse(holidayList.get(i), this.mDateFormatter), (String)"LocalDate.parse(holidayList[i],mDateFormatter)");
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException("setLegalHolidayList\u96c6\u5408\u4e2d\u7684\u53c2\u6570\u9700\u8981 yyyy-MM-dd \u683c\u5f0f\u7684\u65e5\u671f");
            }
            LocalDate holidayLocalDate = localDate;
            this.mHolidayList.add(holidayLocalDate);
            ++i;
        }
        n2 = ((Collection)workdayList).size();
        for (i = 0; i < n2; ++i) {
            try {
                Intrinsics.checkExpressionValueIsNotNull((Object)LocalDate.parse(workdayList.get(i), this.mDateFormatter), (String)"LocalDate.parse(workdayList[i],mDateFormatter)");
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException("setLegalHolidayList\u96c6\u5408\u4e2d\u7684\u53c2\u6570\u9700\u8981 yyyy-MM-dd \u683c\u5f0f\u7684\u65e5\u671f");
            }
            LocalDate workdayLocalDate = localDate;
            this.mWorkdayList.add(workdayLocalDate);
        }
        this.iCalendar.notifyCalendar();
    }

    public final void setStretchStrMap(@NotNull Map<String, String> stretchStrMap) {
        Intrinsics.checkParameterIsNotNull(stretchStrMap, (String)"stretchStrMap");
        this.mStretchStrMap.clear();
        for (String key : stretchStrMap.keySet()) {
            LocalDate localDate;
            try {
                Intrinsics.checkExpressionValueIsNotNull((Object)LocalDate.parse(key, this.mDateFormatter), (String)"LocalDate.parse(key,mDateFormatter)");
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException("setStretchStrMap\u7684\u53c2\u6570\u9700\u8981 yyyy-MM-dd \u683c\u5f0f\u7684\u65e5\u671f");
            }
            LocalDate localDate2 = localDate;
            this.mStretchStrMap.put(localDate2, stretchStrMap.get(key));
        }
        this.iCalendar.notifyCalendar();
    }

    private final Rect getDrawableBounds(int centerX, int centerY, Drawable drawable) {
        if (drawable == null) {
            return new Rect();
        }
        return new Rect(centerX - drawable.getIntrinsicWidth() / 2, centerY - drawable.getIntrinsicHeight() / 2, centerX + drawable.getIntrinsicWidth() / 2, centerY + drawable.getIntrinsicHeight() / 2);
    }

    @NotNull
    public final ICalendar getICalendar() {
        return this.iCalendar;
    }

    public InnerPainter(@NotNull Context mContext, @NotNull ICalendar iCalendar) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)iCalendar, (String)"iCalendar");
        this.mContext = mContext;
        this.iCalendar = iCalendar;
        this.mTextPaint = new Paint();
        this.noAlphaColor = 255;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-M-d");
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeFormatter, (String)"DateTimeFormatter.ofPattern(\"yyyy-M-d\")");
        this.mDateFormatter = dateTimeFormatter;
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mPointList = new ArrayList();
        this.mHolidayList = new ArrayList();
        this.mWorkdayList = new ArrayList();
        this.mReplaceLunarStrMap = new HashMap();
        this.mReplaceLunarColorMap = new HashMap();
        this.mStretchStrMap = new HashMap();
        this.mDefaultCheckedBackground = ContextCompat.getDrawable((Context)this.mContext, (int)NAttrs.INSTANCE.getDefaultCheckedBackground());
        this.mTodayCheckedBackground = ContextCompat.getDrawable((Context)this.mContext, (int)NAttrs.INSTANCE.getTodayCheckedBackground());
        this.mDefaultCheckedPoint = ContextCompat.getDrawable((Context)this.mContext, (int)NAttrs.INSTANCE.getDefaultCheckedPoint());
        this.mDefaultUnCheckedPoint = ContextCompat.getDrawable((Context)this.mContext, (int)NAttrs.INSTANCE.getDefaultUnCheckedPoint());
        this.mTodayCheckedPoint = ContextCompat.getDrawable((Context)this.mContext, (int)NAttrs.INSTANCE.getTodayCheckedPoint());
        this.mTodayUnCheckedPoint = ContextCompat.getDrawable((Context)this.mContext, (int)NAttrs.INSTANCE.getTodayUnCheckedPoint());
    }
}

