/*
 * Decompiled with CFR 0.152.
 */
package com.necer.drawable;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.necer.utils.NAttrs;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0012\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/necer/drawable/TextDrawable;", "Landroid/graphics/drawable/Drawable;", "()V", "text", "", "textPaint", "Landroid/graphics/Paint;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "", "getTextBaseLineY", "", "centerY", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setText", "ncalendar_release"})
public final class TextDrawable
extends Drawable {
    private final Paint textPaint = new Paint();
    private String text;

    public final void setText(@Nullable String text) {
        this.text = text;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Rect rect = this.getBounds();
        Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"bounds");
        Rect rect2 = rect;
        String string2 = this.text;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawText(string2, (float)rect2.centerX(), this.getTextBaseLineY(rect2.centerY()), this.textPaint);
    }

    public void setAlpha(int alpha) {
        this.textPaint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.textPaint.setColorFilter(colorFilter);
    }

    @SuppressLint(value={"WrongConstant"})
    public int getOpacity() {
        return 0;
    }

    private final float getTextBaseLineY(float centerY) {
        Paint.FontMetrics fontMetrics = this.textPaint.getFontMetrics();
        return centerY - (fontMetrics.bottom - fontMetrics.top) / (float)2 - fontMetrics.top;
    }

    public TextDrawable() {
        this.textPaint.setAntiAlias(true);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textPaint.setTextSize(NAttrs.INSTANCE.getNumberBackgroundTextSize());
        this.textPaint.setColor(NAttrs.INSTANCE.getNumberBackgroundTextColor());
        this.textPaint.setAlpha(NAttrs.INSTANCE.getBackgroundAlphaColor());
    }
}

