/*
 * Decompiled with CFR 0.152.
 */
package com.necer.calendar;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.core.view.NestedScrollingParent;
import com.necer.R;
import com.necer.calendar.ICalendar;
import com.necer.calendar.NCalendar$WhenMappings;
import com.necer.calendar.NViewPager;
import com.necer.calendar.NWeekBar;
import com.necer.enumeration.CalendarState;
import com.necer.enumeration.CheckModel;
import com.necer.enumeration.MultipleCountModel;
import com.necer.listener.OnCalendarChangedListener;
import com.necer.listener.OnCalendarMultipleChangedListener;
import com.necer.listener.OnCalendarStateChangedListener;
import com.necer.listener.OnClickDisableDateListener;
import com.necer.listener.OnEndAnimatorListener;
import com.necer.painter.CalendarPainter;
import com.necer.utils.NAttrs;
import com.necer.utils.NAttrsUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0015\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u000eH\u0002J\u0010\u0010/\u001a\u00020*2\u0006\u0010.\u001a\u00020\u000eH\u0002J\b\u00100\u001a\u000201H\u0016J\n\u00102\u001a\u0004\u0018\u00010\u0015H\u0016J\u0006\u00103\u001a\u00020\u000eJ\b\u00104\u001a\u000205H\u0016J\u0006\u00106\u001a\u00020\u000eJ\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020908H\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020908H\u0016J\u0006\u0010;\u001a\u00020\fJ\u0012\u0010<\u001a\u0004\u0018\u00010\u00152\u0006\u0010=\u001a\u00020\u000eH\u0002J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020908H\u0016J\u0006\u0010?\u001a\u00020\fJ\u0010\u0010@\u001a\u00020\u00112\u0006\u0010A\u001a\u00020\u000eH\u0002J\b\u0010B\u001a\u00020\u0011H\u0002J \u0010C\u001a\u00020*2\u0006\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020\fH\u0016J\u0012\u0010C\u001a\u00020*2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\u0018\u0010I\u001a\u00020*2\u0006\u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\fH\u0016J\b\u0010J\u001a\u00020*H\u0016J\b\u0010K\u001a\u00020*H\u0014J\u0010\u0010L\u001a\u00020\u00112\u0006\u0010M\u001a\u00020NH\u0016J0\u0010O\u001a\u00020*2\u0006\u0010P\u001a\u00020\u00112\u0006\u0010Q\u001a\u00020\f2\u0006\u0010R\u001a\u00020\f2\u0006\u0010S\u001a\u00020\f2\u0006\u0010T\u001a\u00020\fH\u0014J\u0018\u0010U\u001a\u00020*2\u0006\u0010V\u001a\u00020\f2\u0006\u0010W\u001a\u00020\fH\u0014J \u0010X\u001a\u00020\u00112\u0006\u0010Y\u001a\u00020#2\u0006\u0010Z\u001a\u00020\u000e2\u0006\u0010[\u001a\u00020\u000eH\u0016J(\u0010\\\u001a\u00020*2\u0006\u0010Y\u001a\u00020#2\u0006\u0010]\u001a\u00020\f2\u0006\u0010.\u001a\u00020\f2\u0006\u0010^\u001a\u00020_H\u0016J \u0010`\u001a\u00020\u00112\u0006\u0010a\u001a\u00020#2\u0006\u0010Y\u001a\u00020#2\u0006\u0010b\u001a\u00020\fH\u0016J\u0010\u0010c\u001a\u00020*2\u0006\u0010a\u001a\u00020#H\u0016J\u0010\u0010d\u001a\u00020\u00112\u0006\u0010e\u001a\u00020NH\u0016J\u0012\u0010f\u001a\u00020*2\b\u0010g\u001a\u0004\u0018\u000101H\u0016J\u0010\u0010h\u001a\u00020*2\u0006\u0010i\u001a\u000205H\u0016J\u0016\u0010j\u001a\u00020*2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020H08H\u0016J\u001c\u0010l\u001a\u00020*2\b\u0010m\u001a\u0004\u0018\u00010H2\b\u0010n\u001a\u0004\u0018\u00010HH\u0016J&\u0010l\u001a\u00020*2\b\u0010m\u001a\u0004\u0018\u00010H2\b\u0010n\u001a\u0004\u0018\u00010H2\b\u0010o\u001a\u0004\u0018\u00010HH\u0016J\u0012\u0010p\u001a\u00020*2\b\u0010o\u001a\u0004\u0018\u00010HH\u0016J\u001a\u0010q\u001a\u00020*2\u0006\u0010r\u001a\u00020\f2\b\u0010s\u001a\u0004\u0018\u00010tH\u0016J\u0012\u0010u\u001a\u00020*2\b\u0010v\u001a\u0004\u0018\u00010wH\u0016J\u0012\u0010x\u001a\u00020*2\b\u0010y\u001a\u0004\u0018\u00010zH\u0016J\u0012\u0010{\u001a\u00020*2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010|\u001a\u00020*2\b\u0010}\u001a\u0004\u0018\u00010~H\u0016J\u0010\u0010\u007f\u001a\u00020*2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J#\u0010\u0080\u0001\u001a\u00020*2\u0007\u0010\u0081\u0001\u001a\u00020\u000e2\u0007\u0010\u0082\u0001\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0002J\t\u0010\u0083\u0001\u001a\u00020*H\u0016J\t\u0010\u0084\u0001\u001a\u00020*H\u0016J\t\u0010\u0085\u0001\u001a\u00020*H\u0016J\t\u0010\u0086\u0001\u001a\u00020*H\u0016J\t\u0010\u0087\u0001\u001a\u00020*H\u0016J\t\u0010\u0088\u0001\u001a\u00020*H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0089\u0001"}, d2={"Lcom/necer/calendar/NCalendar;", "Landroid/widget/LinearLayout;", "Lcom/necer/calendar/ICalendar;", "Landroidx/core/view/NestedScrollingParent;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "childView", "Landroid/widget/FrameLayout;", "directionY", "", "downX", "", "downY", "isFirstMove", "", "isLayout", "isWeekHoldEnable", "lastCalendarState", "Lcom/necer/enumeration/CalendarState;", "lastY", "monthHeight", "monthStateY", "nViewPager", "Lcom/necer/calendar/NViewPager;", "nWeekBar", "Lcom/necer/calendar/NWeekBar;", "onCalendarStateChangedListener", "Lcom/necer/listener/OnCalendarStateChangedListener;", "previousValue", "stretchHeight", "stretchStateY", "targetView", "Landroid/view/View;", "valueAnimator", "Landroid/animation/ValueAnimator;", "verticalY", "weekHeight", "weekStateY", "autoScroll", "", "duration", "", "calendarTranslate", "dy", "gestureMove", "getCalendarPainter", "Lcom/necer/painter/CalendarPainter;", "getCalendarState", "getCanvasHeight", "getCheckModel", "Lcom/necer/enumeration/CheckModel;", "getChildY", "getCurrPagerCheckDateList", "", "Ljava/time/LocalDate;", "getCurrPagerDateList", "getMonthStateY", "getPreCalendarState", "childY", "getTotalCheckedDateList", "getWeekStateY", "interceptTouch", "offsetY", "isInCalendar", "jumpDate", "year", "month", "day", "formatDate", "", "jumpMonth", "notifyCalendar", "onFinishInflate", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onLayout", "changed", "l", "t", "r", "b", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onNestedPreFling", "target", "velocityX", "velocityY", "onNestedPreScroll", "dx", "consumed", "", "onStartNestedScroll", "child", "nestedScrollAxes", "onStopNestedScroll", "onTouchEvent", "event", "setCalendarPainter", "calendarPainter", "setCheckMode", "checkModel", "setCheckedDates", "dateList", "setDateInterval", "startFormatDate", "endFormatDate", "formatInitializeDate", "setInitializeDate", "setMultipleCount", "multipleCount", "multipleCountModel", "Lcom/necer/enumeration/MultipleCountModel;", "setOnCalendarChangedListener", "onCalendarChangedListener", "Lcom/necer/listener/OnCalendarChangedListener;", "setOnCalendarMultipleChangedListener", "onCalendarMultipleChangedListener", "Lcom/necer/listener/OnCalendarMultipleChangedListener;", "setOnCalendarStateChangedListener", "setOnClickDisableDateListener", "onClickDisableDateListener", "Lcom/necer/listener/OnClickDisableDateListener;", "setWeekHoldEnable", "startAutoScroll", "startY", "endY", "toLastPager", "toMonth", "toNextPager", "toStretch", "toToday", "toWeek", "ncalendar_release"})
public final class NCalendar
extends LinearLayout
implements ICalendar,
NestedScrollingParent {
    private NWeekBar nWeekBar;
    private NViewPager nViewPager;
    private int monthHeight;
    private int stretchHeight;
    private int weekHeight;
    private int monthStateY;
    private int weekStateY;
    private int stretchStateY;
    private ValueAnimator valueAnimator;
    private float previousValue;
    private FrameLayout childView;
    private View targetView;
    private boolean isLayout;
    private CalendarState lastCalendarState;
    private OnCalendarStateChangedListener onCalendarStateChangedListener;
    private boolean isWeekHoldEnable;
    private float downY;
    private float downX;
    private float lastY;
    private final float verticalY = 30.0f;
    private int directionY;
    private boolean isFirstMove;

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() > 4) {
            throw (Throwable)new RuntimeException(this.getContext().getString(R.string.N_NCalendar_child_num));
        }
        if (this.getChildCount() == 4) {
            View view;
            View view2 = view = this.getChildAt(3);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view");
            ViewParent viewParent = view2.getParent();
            if (viewParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
            }
            ((ViewGroup)viewParent).removeView(view);
            this.childView.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        block5: {
            block6: {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                if (this.isLayout) break block5;
                if (this.childView.getChildCount() == 0) break block6;
                childLayoutParams = this.childView.getLayoutParams();
                childLayoutParams.height = this.getMeasuredHeight() - this.weekHeight - this.nWeekBar.getMeasuredHeight();
                this.monthStateY = this.nWeekBar.getMeasuredHeight() + this.monthHeight;
                this.weekStateY = this.nWeekBar.getMeasuredHeight() + this.weekHeight;
                this.stretchStateY = this.nWeekBar.getMeasuredHeight() + this.stretchHeight;
                break block5;
            }
            v0 = this.getCalendarState();
            if (v0 == null) ** GOTO lbl-1000
            switch (NCalendar$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                case 1: {
                    v1 = this.weekHeight;
                    break;
                }
                case 2: {
                    v1 = this.monthHeight;
                    break;
                }
                case 3: {
                    v1 = this.stretchHeight;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v1 = 0;
                }
            }
            height = v1;
            viewPagerLayoutParams = this.nViewPager.getLayoutParams();
            viewPagerLayoutParams.height = height;
            this.getLayoutParams().height = height + this.nWeekBar.getMeasuredHeight();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        block5: {
            super.onLayout(changed, l, t, r, b);
            if (this.isLayout) break block5;
            v0 = this.getCalendarState();
            if (v0 == null) ** GOTO lbl-1000
            switch (NCalendar$WhenMappings.$EnumSwitchMapping$1[v0.ordinal()]) {
                case 1: {
                    v1 = this.weekStateY;
                    break;
                }
                case 2: {
                    v1 = this.monthStateY;
                    break;
                }
                case 3: {
                    v1 = this.stretchStateY;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v1 = 0;
                }
            }
            childY = v1;
            this.childView.setY((float)childY);
            this.isLayout = true;
        }
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkParameterIsNotNull((Object)ev, (String)"ev");
        if (this.childView.getChildCount() == 0) {
            return super.onInterceptTouchEvent(ev);
        }
        if (this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
        }
        switch (ev.getAction()) {
            case 0: {
                this.downY = ev.getY();
                this.downX = ev.getX();
                this.lastY = this.downY;
                break;
            }
            case 2: {
                if (this.nViewPager.getCalendarState() == null) {
                    return true;
                }
                float y = ev.getY();
                float offsetY = this.downY - y;
                return this.interceptTouch(offsetY);
            }
            case 1: 
            case 3: {
                if (!(this.downY > (float)this.weekStateY) || !(this.downY < this.childView.getY())) break;
                this.isFirstMove = true;
                this.autoScroll(NAttrs.INSTANCE.getAnimationDuration());
                break;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    private final boolean interceptTouch(float offsetY) {
        float absY = Math.abs(offsetY);
        boolean condition = false;
        if (this.targetView == null) {
            condition = true;
        } else if (this.isInCalendar()) {
            View view = this.targetView;
            if (view == null) {
                Intrinsics.throwNpe();
            }
            if (!view.canScrollVertically(-1)) {
                condition = true;
            }
        }
        return condition && absY > this.verticalY;
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        switch (event.getAction()) {
            case 2: {
                float y = event.getY();
                float dy = this.lastY - y;
                if (this.isFirstMove) {
                    if (dy >= this.verticalY) {
                        dy -= this.verticalY;
                    } else if (dy < -this.verticalY) {
                        dy += this.verticalY;
                    }
                    this.isFirstMove = false;
                }
                int n = this.directionY = dy > 0.0f ? 1 : -1;
                if (!(Math.abs(dy) > 0.0f)) break;
                this.gestureMove(dy);
                this.lastY = y;
                break;
            }
            case 1: 
            case 3: {
                this.isFirstMove = true;
                this.autoScroll(NAttrs.INSTANCE.getAnimationDuration());
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    private final void gestureMove(float dy) {
        int maxY;
        if (this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
        }
        if (Math.round(this.childView.getY()) == this.weekStateY && this.isWeekHoldEnable) {
            return;
        }
        float childY = this.childView.getY() - dy;
        int n = maxY = NAttrs.INSTANCE.getStretchCalendarEnable() ? this.stretchStateY : this.monthStateY;
        if (childY <= (float)this.weekStateY) {
            childY = this.weekStateY;
        } else if (childY >= (float)maxY) {
            childY = maxY;
        }
        this.childView.setY(childY);
        this.calendarTranslate(dy);
        CalendarState preCalendarState = this.getPreCalendarState(this.childView.getY());
        if (preCalendarState != null) {
            this.nViewPager.setCalendarState(preCalendarState);
        }
    }

    private final void calendarTranslate(float dy) {
        if (Math.round(dy) == 0) {
            return;
        }
        float holdHeight = this.nViewPager.getHoldHeight();
        int heightOffset = this.monthHeight - this.weekHeight;
        float translateRate = holdHeight / (float)heightOffset;
        this.nViewPager.offsetView(dy * translateRate);
    }

    private final boolean isInCalendar() {
        CalendarState calendarState = this.nViewPager.getCalendarState();
        if (calendarState == CalendarState.MONTH) {
            return this.downY <= (float)this.monthStateY;
        }
        if (calendarState == CalendarState.WEEK) {
            return this.downY <= (float)this.weekStateY;
        }
        if (calendarState == CalendarState.MONTH_STRETCH) {
            return this.downY <= (float)this.stretchStateY;
        }
        return false;
    }

    private final void autoScroll(long duration) {
        if (this.valueAnimator.isRunning()) {
            return;
        }
        float startY = this.childView.getY();
        int endY = 0;
        endY = this.directionY == 1 ? (startY >= (float)this.weekStateY && startY <= (float)this.monthStateY ? (startY < (float)(this.monthStateY - this.weekHeight / 2) ? this.weekStateY : this.monthStateY) : (startY < (float)(this.stretchStateY - (this.stretchStateY - this.monthStateY) / 2) ? this.monthStateY : this.stretchStateY)) : (startY >= (float)this.weekStateY && startY <= (float)this.monthStateY ? (startY > (float)(this.weekStateY + this.weekHeight / 2) ? this.monthStateY : this.weekStateY) : (startY > (float)(this.monthStateY + (this.stretchStateY - this.monthStateY) / 2) ? this.stretchStateY : this.monthStateY));
        CalendarState preCalendarState = this.getPreCalendarState(endY);
        if (startY == (float)endY && this.lastCalendarState == preCalendarState) {
            return;
        }
        this.startAutoScroll(startY, endY, duration);
    }

    private final void startAutoScroll(float startY, float endY, long duration) {
        this.valueAnimator = new ValueAnimator();
        this.valueAnimator.setDuration(duration);
        this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ NCalendar this$0;

            public final void onAnimationUpdate(@NotNull ValueAnimator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                Object object = animation.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                float currentValue = ((Float)object).floatValue();
                if (NCalendar.access$getPreviousValue$p(this.this$0) != 0.0f) {
                    float delta = NCalendar.access$getPreviousValue$p(this.this$0) - currentValue;
                    NCalendar.access$calendarTranslate(this.this$0, delta);
                    NCalendar.access$getChildView$p(this.this$0).setY(NCalendar.access$getChildView$p(this.this$0).getY() - delta);
                }
                NCalendar.access$setPreviousValue$p(this.this$0, currentValue);
            }
            {
                this.this$0 = nCalendar;
            }
        });
        this.valueAnimator.addListener((Animator.AnimatorListener)new OnEndAnimatorListener(this){
            final /* synthetic */ NCalendar this$0;

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                super.onAnimationEnd(animation);
                NCalendar.access$setPreviousValue$p(this.this$0, 0.0f);
                CalendarState endCalendarState = NCalendar.access$getPreCalendarState(this.this$0, NCalendar.access$getChildView$p(this.this$0).getY());
                if (endCalendarState != null) {
                    NCalendar.access$getNViewPager$p(this.this$0).setCalendarState(endCalendarState);
                    OnCalendarStateChangedListener onCalendarStateChangedListener = NCalendar.access$getOnCalendarStateChangedListener$p(this.this$0);
                    if (onCalendarStateChangedListener != null) {
                        onCalendarStateChangedListener.onCalendarStateChange(endCalendarState);
                    }
                    NCalendar.access$setLastCalendarState$p(this.this$0, endCalendarState);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        this.valueAnimator.setFloatValues(new float[]{startY, endY});
        this.valueAnimator.start();
    }

    public final float getCanvasHeight() {
        if (this.childView.getChildCount() != 0 && !(this.childView.getY() <= (float)this.monthStateY)) {
            return this.childView.getY() - (float)this.nWeekBar.getMeasuredHeight();
        }
        return this.monthHeight;
    }

    public final float getChildY() {
        return this.childView.getY();
    }

    public final int getMonthStateY() {
        return this.monthStateY;
    }

    public final int getWeekStateY() {
        return this.weekStateY;
    }

    @Override
    @Nullable
    public CalendarState getCalendarState() {
        return this.nViewPager.getCalendarState();
    }

    private final CalendarState getPreCalendarState(float childY) {
        int n = Math.round(childY);
        if (n == this.weekStateY) {
            return CalendarState.WEEK;
        }
        if (n == this.monthStateY) {
            return CalendarState.MONTH;
        }
        if (n == this.stretchStateY) {
            return CalendarState.MONTH_STRETCH;
        }
        return null;
    }

    public boolean onStartNestedScroll(@NotNull View child, @NotNull View target, int nestedScrollAxes) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.targetView = target;
        return !this.isWeekHoldEnable || this.getCalendarState() != CalendarState.WEEK;
    }

    public void onNestedPreScroll(@NotNull View target, int dx, int dy, @NotNull int[] consumed) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)consumed, (String)"consumed");
        super.onNestedPreScroll(target, dx, dy, consumed);
        int childY = (int)this.childView.getY();
        int n = this.directionY = dy > 0 ? 1 : -1;
        if (childY > this.weekStateY && childY <= this.stretchStateY) {
            consumed[1] = dy;
            this.gestureMove(dy);
        } else if (dy < 0) {
            View view = this.targetView;
            if (view == null) {
                Intrinsics.throwNpe();
            }
            if (!view.canScrollVertically(-1)) {
                consumed[1] = dy;
                this.gestureMove(dy);
            }
        }
    }

    public boolean onNestedPreFling(@NotNull View target, float velocityX, float velocityY) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        if (velocityY > (float)6000) {
            this.autoScroll(50L);
        } else if (velocityY < (float)-6000) {
            this.autoScroll(50L);
        }
        return Math.round(this.childView.getY()) != this.weekStateY;
    }

    public void onStopNestedScroll(@NotNull View child) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        super.onStopNestedScroll(child);
        this.targetView = null;
        this.autoScroll(NAttrs.INSTANCE.getAnimationDuration());
    }

    @Override
    public void toWeek() {
        this.startAutoScroll(this.childView.getY(), this.weekStateY, NAttrs.INSTANCE.getAnimationDuration());
    }

    @Override
    public void toMonth() {
        this.startAutoScroll(this.childView.getY(), this.monthStateY, NAttrs.INSTANCE.getAnimationDuration());
    }

    @Override
    public void toStretch() {
        if (NAttrs.INSTANCE.getStretchCalendarEnable()) {
            this.startAutoScroll(this.childView.getY(), this.stretchStateY, NAttrs.INSTANCE.getAnimationDuration());
        }
    }

    @Override
    public void setWeekHoldEnable(boolean isWeekHoldEnable) {
        this.isWeekHoldEnable = isWeekHoldEnable;
    }

    @Override
    public void setCheckMode(@NotNull CheckModel checkModel) {
        Intrinsics.checkParameterIsNotNull((Object)checkModel, (String)"checkModel");
        this.nViewPager.setCheckMode(checkModel);
    }

    @Override
    @NotNull
    public CheckModel getCheckModel() {
        return this.nViewPager.getCheckMode();
    }

    @Override
    public void setMultipleCount(int multipleCount, @Nullable MultipleCountModel multipleCountModel) {
        this.nViewPager.setMultipleCount(multipleCount, multipleCountModel);
    }

    @Override
    public void jumpDate(@Nullable String formatDate) {
        LocalDate localDate;
        LocalDate localDate2 = localDate = LocalDate.parse(formatDate, DateTimeFormatter.ofPattern("yyyy-M-d"));
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate2, (String)"localDate");
        this.nViewPager.jumpDate(localDate2, true);
    }

    @Override
    public void jumpDate(int year, int month, int day) {
        LocalDate localDate;
        LocalDate localDate2 = localDate = LocalDate.of(year, month, day);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate2, (String)"localDate");
        this.nViewPager.jumpDate(localDate2, true);
    }

    @Override
    public void jumpMonth(int year, int month) {
        LocalDate localDate;
        LocalDate localDate2 = localDate = LocalDate.of(year, month, 1);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate2, (String)"localDate");
        this.nViewPager.jumpDate(localDate2, false);
    }

    @Override
    public void toLastPager() {
        this.nViewPager.toLastPager();
    }

    @Override
    public void toNextPager() {
        this.nViewPager.toNextPager();
    }

    @Override
    public void toToday() {
        this.nViewPager.toToday();
    }

    @Override
    public void setCalendarPainter(@Nullable CalendarPainter calendarPainter) {
        this.nViewPager.setCalendarPainter(calendarPainter);
    }

    @Override
    public void notifyCalendar() {
        this.nViewPager.notifyAllView();
    }

    @Override
    public void setInitializeDate(@Nullable String formatInitializeDate) {
        LocalDate localDate = LocalDate.parse(formatInitializeDate, DateTimeFormatter.ofPattern("yyyy-M-dd"));
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDate.parse(\n       \u2026yyyy-M-dd\")\n            )");
        this.nViewPager.setInitializeDate(localDate);
    }

    @Override
    public void setDateInterval(@Nullable String startFormatDate, @Nullable String endFormatDate, @Nullable String formatInitializeDate) {
        this.nViewPager.setDateInterval(startFormatDate, endFormatDate, formatInitializeDate);
    }

    @Override
    public void setDateInterval(@Nullable String startFormatDate, @Nullable String endFormatDate) {
        this.nViewPager.setDateInterval(startFormatDate, endFormatDate);
    }

    @Override
    public void setOnCalendarChangedListener(@Nullable OnCalendarChangedListener onCalendarChangedListener) {
        this.nViewPager.setOnCalendarChangedListener(onCalendarChangedListener);
    }

    @Override
    public void setOnCalendarMultipleChangedListener(@Nullable OnCalendarMultipleChangedListener onCalendarMultipleChangedListener) {
        this.nViewPager.setOnCalendarMultipleChangedListener(onCalendarMultipleChangedListener);
    }

    @Override
    public void setOnClickDisableDateListener(@Nullable OnClickDisableDateListener onClickDisableDateListener) {
        this.nViewPager.setOnClickDisableDateListener(onClickDisableDateListener);
    }

    @Override
    @NotNull
    public CalendarPainter getCalendarPainter() {
        return this.nViewPager.getCalendarPainter();
    }

    @Override
    @NotNull
    public List<LocalDate> getTotalCheckedDateList() {
        return this.nViewPager.getTotalCheckedDateList();
    }

    @Override
    @NotNull
    public List<LocalDate> getCurrPagerCheckDateList() {
        return this.nViewPager.getCurrPagerCheckedDateList();
    }

    @Override
    @NotNull
    public List<LocalDate> getCurrPagerDateList() {
        return this.nViewPager.getCurrPagerDateList();
    }

    @Override
    public void setCheckedDates(@NotNull List<String> dateList) {
        Intrinsics.checkParameterIsNotNull(dateList, (String)"dateList");
        this.nViewPager.setCheckedDates(dateList);
    }

    @Override
    public void setOnCalendarStateChangedListener(@Nullable OnCalendarStateChangedListener onCalendarStateChangedListener) {
        this.onCalendarStateChangedListener = onCalendarStateChangedListener;
    }

    public NCalendar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.valueAnimator = new ValueAnimator();
        this.setOrientation(1);
        this.setMotionEventSplittingEnabled(false);
        NAttrsUtil.INSTANCE.setAttrs(context, attrs);
        this.monthHeight = NAttrs.INSTANCE.getCalendarHeight();
        this.weekHeight = this.monthHeight / 5;
        this.stretchHeight = NAttrs.INSTANCE.getStretchCalendarHeight();
        if (this.stretchHeight <= this.monthHeight) {
            throw (Throwable)new RuntimeException("\u62c9\u4f38\u72b6\u6001\u7684\u9ad8\u5ea6\u5fc5\u987b\u5927\u4e8e\u6708\u65e5\u5386\u9ad8\u5ea6");
        }
        this.nWeekBar = new NWeekBar(context, null);
        this.nViewPager = new NViewPager(context, null);
        this.addView((View)this.nWeekBar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, NAttrs.INSTANCE.getWeekBarHeight() == 0 ? -2 : NAttrs.INSTANCE.getWeekBarHeight()));
        this.addView((View)this.nViewPager, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.stretchHeight));
        this.childView = new FrameLayout(context);
        this.childView.setClickable(true);
        this.childView.setBackgroundColor(-1);
        this.addView((View)this.childView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.verticalY = 30.0f;
        this.isFirstMove = true;
    }

    public static final /* synthetic */ float access$getPreviousValue$p(NCalendar $this) {
        return $this.previousValue;
    }

    public static final /* synthetic */ void access$setPreviousValue$p(NCalendar $this, float f) {
        $this.previousValue = f;
    }

    public static final /* synthetic */ void access$calendarTranslate(NCalendar $this, float dy) {
        $this.calendarTranslate(dy);
    }

    public static final /* synthetic */ FrameLayout access$getChildView$p(NCalendar $this) {
        return $this.childView;
    }

    public static final /* synthetic */ void access$setChildView$p(NCalendar $this, FrameLayout frameLayout) {
        $this.childView = frameLayout;
    }

    public static final /* synthetic */ CalendarState access$getPreCalendarState(NCalendar $this, float childY) {
        return $this.getPreCalendarState(childY);
    }

    public static final /* synthetic */ NViewPager access$getNViewPager$p(NCalendar $this) {
        return $this.nViewPager;
    }

    public static final /* synthetic */ void access$setNViewPager$p(NCalendar $this, NViewPager nViewPager) {
        $this.nViewPager = nViewPager;
    }

    public static final /* synthetic */ OnCalendarStateChangedListener access$getOnCalendarStateChangedListener$p(NCalendar $this) {
        return $this.onCalendarStateChangedListener;
    }

    public static final /* synthetic */ void access$setOnCalendarStateChangedListener$p(NCalendar $this, OnCalendarStateChangedListener onCalendarStateChangedListener) {
        $this.onCalendarStateChangedListener = onCalendarStateChangedListener;
    }

    public static final /* synthetic */ CalendarState access$getLastCalendarState$p(NCalendar $this) {
        return $this.lastCalendarState;
    }

    public static final /* synthetic */ void access$setLastCalendarState$p(NCalendar $this, CalendarState calendarState) {
        $this.lastCalendarState = calendarState;
    }
}

