/*
 * Decompiled with CFR 0.152.
 */
package com.github.yangkangli.logger.adapter;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.github.yangkangli.logger.core.BaseLogStrategy;
import com.github.yangkangli.logger.core.ILogAdapter;
import com.github.yangkangli.logger.utils.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class DiskAdapter
implements ILogAdapter {
    private boolean loggable;
    private String logFilePath;
    private SimpleDateFormat simpleDateFormat;
    private SimpleDateFormat fileNameFormat;
    private WriteHandler writeHandler;

    private DiskAdapter(Builder builder) {
        this.loggable = builder.loggable;
        this.logFilePath = builder.logFilePath;
        this.simpleDateFormat = new SimpleDateFormat(builder.formatPattern);
        this.fileNameFormat = new SimpleDateFormat("yyyy-MM-dd");
        HandlerThread thread = new HandlerThread("AndroidFileLogger");
        thread.start();
        this.writeHandler = new WriteHandler(thread.getLooper(), this);
    }

    @Override
    public boolean isLoggable() {
        return this.loggable;
    }

    @Override
    public void log(int priority, String subTag, String message, BaseLogStrategy strategy) {
        String commonInfo = this.simpleDateFormat.format(new Date()) + " " + Utils.getLevelName(priority) + "/" + this.getFullTag(strategy, subTag) + ": ";
        ArrayList<String> lines = new ArrayList<String>();
        String topBorder = Utils.getTopBorder(subTag, strategy.getBorderMaxLength(), strategy.getLinkerLength());
        lines.add(commonInfo + topBorder);
        if (strategy.isShowThreadName()) {
            String threadName = "| Thread:" + Thread.currentThread().getName();
            lines.add(commonInfo + threadName);
            String divider = Utils.getDivider(subTag, strategy.getBorderMaxLength(), strategy.getLinkerLength());
            lines.add(commonInfo + divider);
        }
        if (strategy.isShowStackTrace()) {
            String level = "";
            List<StackTraceElement> traceList = Utils.getTraceList(Thread.currentThread().getStackTrace(), strategy.getMethodCount());
            Iterator iterator = traceList.iterator();
            while (iterator.hasNext()) {
                StackTraceElement element = (StackTraceElement)iterator.next();
                StringBuilder builder = new StringBuilder();
                builder.append("|").append(' ').append(level).append(Utils.getSimpleClassName(element.getClassName())).append(".").append(element.getMethodName()).append(" ").append(" (").append(element.getFileName()).append(":").append(element.getLineNumber()).append(")");
                level = level + "    ";
                lines.add(commonInfo + builder.toString());
            }
            String divider = Utils.getDivider(subTag, strategy.getBorderMaxLength(), strategy.getLinkerLength());
            lines.add(commonInfo + divider);
        }
        String[] strings = Utils.splitMessage(message);
        for (String msg : strings) {
            lines.add(commonInfo + "|" + " " + (String)msg);
        }
        String bottomBorder = Utils.getBottomBorder(subTag, strategy.getBorderMaxLength(), strategy.getLinkerLength());
        lines.add(commonInfo + bottomBorder);
        this.writeHandler.sendMessage(this.writeHandler.obtainMessage(priority, lines));
    }

    private void writeLog(List<String> lines) {
        block5: {
            OutputStreamWriter fileWriter = null;
            try {
                File logFile = this.getLogFile();
                fileWriter = new FileWriter(logFile, true);
                for (String line : lines) {
                    fileWriter.append(line).append("\n");
                }
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception e) {
                if (fileWriter == null) break block5;
                try {
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private File getLogFile() throws IOException {
        File logFile;
        File folder = new File(this.logFilePath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(logFile = new File(folder, String.format("%s.log", this.fileNameFormat.format(new Date())))).exists()) {
            logFile.createNewFile();
        }
        return logFile;
    }

    private String getFullTag(BaseLogStrategy strategy, String subTag) {
        if (!TextUtils.isEmpty((CharSequence)subTag)) {
            return strategy.getBaseTag() + strategy.getLinker() + subTag;
        }
        return strategy.getBaseTag();
    }

    public static class Builder {
        private boolean loggable = true;
        private String logFilePath;
        private String formatPattern = "yyyy-MM-dd HH:mm:ss.SSS";

        public Builder setLoggable(boolean loggable) {
            this.loggable = loggable;
            return this;
        }

        public Builder setLogFilePath(String path) {
            this.logFilePath = path;
            return this;
        }

        public Builder setFormatPattern(String pattern) {
            this.formatPattern = pattern;
            return this;
        }

        public DiskAdapter build() {
            return new DiskAdapter(this);
        }
    }

    public static class WriteHandler
    extends Handler {
        private WeakReference<DiskAdapter> adapterReference;

        public WriteHandler(@NonNull Looper looper, DiskAdapter adapter) {
            super(Utils.checkNotNull(looper));
            this.adapterReference = new WeakReference<DiskAdapter>(adapter);
        }

        public void handleMessage(@NonNull Message msg) {
            DiskAdapter diskAdapter = (DiskAdapter)this.adapterReference.get();
            if (diskAdapter != null) {
                diskAdapter.writeLog((List)msg.obj);
            }
        }
    }
}

