/*
 * Decompiled with CFR 0.152.
 */
package com.github.yangkangli.logger.adapter;

import android.text.TextUtils;
import android.util.Log;
import com.github.yangkangli.logger.core.BaseLogStrategy;
import com.github.yangkangli.logger.core.ILogAdapter;
import com.github.yangkangli.logger.utils.Utils;
import java.util.Iterator;
import java.util.List;

public class ConsoleAdapter
implements ILogAdapter {
    private boolean loggable;

    private ConsoleAdapter(Builder builder) {
        this.loggable = builder.loggable;
    }

    @Override
    public boolean isLoggable() {
        return this.loggable;
    }

    @Override
    public void log(int priority, String subTag, String message, BaseLogStrategy strategy) {
        String tag = this.getFullTag(strategy, subTag);
        String topBorder = Utils.getTopBorder(subTag, strategy.getBorderMaxLength(), strategy.getLinkerLength());
        Log.println((int)priority, (String)tag, (String)topBorder);
        if (strategy.isShowThreadName()) {
            String threadName = "| Thread:" + Thread.currentThread().getName();
            Log.println((int)priority, (String)tag, (String)threadName);
            String divider = Utils.getDivider(subTag, strategy.getBorderMaxLength(), strategy.getLinkerLength());
            Log.println((int)priority, (String)tag, (String)divider);
        }
        if (strategy.isShowStackTrace()) {
            String level = "";
            List<StackTraceElement> traceList = Utils.getTraceList(Thread.currentThread().getStackTrace(), strategy.getMethodCount());
            Iterator iterator = traceList.iterator();
            while (iterator.hasNext()) {
                StackTraceElement element = (StackTraceElement)iterator.next();
                StringBuilder builder = new StringBuilder();
                builder.append("|").append(' ').append(level).append(Utils.getSimpleClassName(element.getClassName())).append(".").append(element.getMethodName()).append(" ").append(" (").append(element.getFileName()).append(":").append(element.getLineNumber()).append(")");
                level = level + "    ";
                Log.println((int)priority, (String)tag, (String)builder.toString());
            }
            String divider = Utils.getDivider(subTag, strategy.getBorderMaxLength(), strategy.getLinkerLength());
            Log.println((int)priority, (String)tag, (String)divider);
        }
        String[] strings = Utils.splitMessage(message);
        for (String msg : strings) {
            Log.println((int)priority, (String)tag, (String)("| " + (String)msg));
        }
        String bottomBorder = Utils.getBottomBorder(subTag, strategy.getBorderMaxLength(), strategy.getLinkerLength());
        Log.println((int)priority, (String)tag, (String)bottomBorder);
    }

    private String getFullTag(BaseLogStrategy strategy, String subTag) {
        if (!TextUtils.isEmpty((CharSequence)subTag)) {
            return strategy.getBaseTag() + strategy.getLinker() + subTag;
        }
        return strategy.getBaseTag();
    }

    public static class Builder {
        private boolean loggable = true;

        public Builder setLoggable(boolean loggable) {
            this.loggable = loggable;
            return this;
        }

        public ConsoleAdapter build() {
            return new ConsoleAdapter(this);
        }
    }
}

