/*
 * Decompiled with CFR 0.152.
 */
package VideoHandle;

import Jni.FFmpegCmd;
import Jni.FileUtils;
import Jni.TrackUtils;
import Jni.VideoUitls;
import VideoHandle.CmdList;
import VideoHandle.EpDraw;
import VideoHandle.EpVideo;
import VideoHandle.OnEditorListener;
import android.content.Context;
import android.media.MediaExtractor;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EpEditor {
    private static final int DEFAULT_WIDTH = 480;
    private static final int DEFAULT_HEIGHT = 360;

    private EpEditor() {
    }

    public static void exec(EpVideo epVideo, OutputOption outputOption, OnEditorListener onEditorListener) {
        StringBuilder filter_complex;
        boolean isFilter = false;
        ArrayList<EpDraw> epDraws = epVideo.getEpDraws();
        CmdList cmd = new CmdList();
        cmd.append("ffmpeg");
        cmd.append("-y");
        if (epVideo.getVideoClip()) {
            cmd.append("-ss").append(epVideo.getClipStart()).append("-t").append(epVideo.getClipDuration()).append("-accurate_seek");
        }
        cmd.append("-i").append(epVideo.getVideoPath());
        if (epDraws.size() > 0) {
            int i;
            for (int i2 = 0; i2 < epDraws.size(); ++i2) {
                if (epDraws.get(i2).isAnimation()) {
                    cmd.append("-ignore_loop");
                    cmd.append(0);
                }
                cmd.append("-i").append(epDraws.get(i2).getPicPath());
            }
            cmd.append("-filter_complex");
            filter_complex = new StringBuilder();
            filter_complex.append("[0:v]").append(epVideo.getFilters() != null ? epVideo.getFilters() + "," : "").append("scale=").append(outputOption.width == 0 ? "iw" : Integer.valueOf(outputOption.width)).append(":").append(outputOption.height == 0 ? "ih" : Integer.valueOf(outputOption.height)).append(outputOption.width == 0 ? "" : ",setdar=" + outputOption.getSar()).append("[outv0];");
            for (i = 0; i < epDraws.size(); ++i) {
                filter_complex.append("[").append(i + 1).append(":0]").append(epDraws.get(i).getPicFilter()).append("scale=").append(epDraws.get(i).getPicWidth()).append(":").append(epDraws.get(i).getPicHeight()).append("[outv").append(i + 1).append("];");
            }
            for (i = 0; i < epDraws.size(); ++i) {
                if (i == 0) {
                    filter_complex.append("[outv").append(i).append("]").append("[outv").append(i + 1).append("]");
                } else {
                    filter_complex.append("[outo").append(i - 1).append("]").append("[outv").append(i + 1).append("]");
                }
                filter_complex.append("overlay=").append(epDraws.get(i).getPicX()).append(":").append(epDraws.get(i).getPicY()).append(epDraws.get(i).getTime());
                if (epDraws.get(i).isAnimation()) {
                    filter_complex.append(":shortest=1");
                }
                if (i >= epDraws.size() - 1) continue;
                filter_complex.append("[outo").append(i).append("];");
            }
            cmd.append(filter_complex.toString());
            isFilter = true;
        } else {
            filter_complex = new StringBuilder();
            if (epVideo.getFilters() != null) {
                cmd.append("-filter_complex");
                filter_complex.append((CharSequence)epVideo.getFilters());
                isFilter = true;
            }
            if (outputOption.width != 0) {
                if (epVideo.getFilters() != null) {
                    filter_complex.append(",scale=").append(outputOption.width).append(":").append(outputOption.height).append(",setdar=").append(outputOption.getSar());
                } else {
                    cmd.append("-filter_complex");
                    filter_complex.append("scale=").append(outputOption.width).append(":").append(outputOption.height).append(",setdar=").append(outputOption.getSar());
                    isFilter = true;
                }
            }
            if (!filter_complex.toString().equals("")) {
                cmd.append(filter_complex.toString());
            }
        }
        cmd.append(outputOption.getOutputInfo().split(" "));
        if (!isFilter && outputOption.getOutputInfo().isEmpty()) {
            cmd.append("-vcodec");
            cmd.append("copy");
            cmd.append("-acodec");
            cmd.append("copy");
        } else {
            cmd.append("-preset");
            cmd.append("superfast");
        }
        cmd.append(outputOption.outPath);
        long duration = VideoUitls.getDuration(epVideo.getVideoPath());
        if (epVideo.getVideoClip()) {
            long clipTime = (long)((epVideo.getClipDuration() - epVideo.getClipStart()) * 1000000.0f);
            duration = clipTime < duration ? clipTime : duration;
        }
        EpEditor.execCmd(cmd, duration, onEditorListener);
    }

    public static void merge(List<EpVideo> epVideos, OutputOption outputOption, OnEditorListener onEditorListener) {
        long duration;
        CmdList cmd;
        boolean isNoAudioTrack = false;
        for (EpVideo epVideo : epVideos) {
            MediaExtractor mediaExtractor = new MediaExtractor();
            try {
                mediaExtractor.setDataSource(epVideo.getVideoPath());
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            int at = TrackUtils.selectAudioTrack(mediaExtractor);
            if (at == -1) {
                isNoAudioTrack = true;
                mediaExtractor.release();
                break;
            }
            mediaExtractor.release();
        }
        outputOption.width = outputOption.width == 0 ? 480 : outputOption.width;
        outputOption.height = outputOption.height == 0 ? 360 : outputOption.height;
        if (epVideos.size() > 1) {
            int i;
            cmd = new CmdList();
            cmd.append("ffmpeg");
            cmd.append("-y");
            for (EpVideo e : epVideos) {
                if (e.getVideoClip()) {
                    cmd.append("-ss").append(e.getClipStart()).append("-t").append(e.getClipDuration()).append("-accurate_seek");
                }
                cmd.append("-i").append(e.getVideoPath());
            }
            for (EpVideo e : epVideos) {
                ArrayList<EpDraw> epDraws = e.getEpDraws();
                if (epDraws.size() <= 0) continue;
                for (EpDraw ep : epDraws) {
                    if (ep.isAnimation()) {
                        cmd.append("-ignore_loop").append(0);
                    }
                    cmd.append("-i").append(ep.getPicPath());
                }
            }
            cmd.append("-filter_complex");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < epVideos.size(); ++i2) {
                StringBuilder filter = epVideos.get(i2).getFilters() == null ? new StringBuilder("") : epVideos.get(i2).getFilters().append(",");
                stringBuilder.append("[").append(i2).append(":v]").append((CharSequence)filter).append("scale=").append(outputOption.width).append(":").append(outputOption.height).append(",setdar=").append(outputOption.getSar()).append("[outv").append(i2).append("];");
            }
            int drawNum = epVideos.size();
            for (i = 0; i < epVideos.size(); ++i) {
                for (int j = 0; j < epVideos.get(i).getEpDraws().size(); ++j) {
                    stringBuilder.append("[").append(drawNum++).append(":0]").append(epVideos.get(i).getEpDraws().get(j).getPicFilter()).append("scale=").append(epVideos.get(i).getEpDraws().get(j).getPicWidth()).append(":").append(epVideos.get(i).getEpDraws().get(j).getPicHeight()).append("[p").append(i).append("a").append(j).append("];");
                }
            }
            for (i = 0; i < epVideos.size(); ++i) {
                for (int j = 0; j < epVideos.get(i).getEpDraws().size(); ++j) {
                    stringBuilder.append("[outv").append(i).append("][p").append(i).append("a").append(j).append("]overlay=").append(epVideos.get(i).getEpDraws().get(j).getPicX()).append(":").append(epVideos.get(i).getEpDraws().get(j).getPicY()).append(epVideos.get(i).getEpDraws().get(j).getTime());
                    if (epVideos.get(i).getEpDraws().get(j).isAnimation()) {
                        stringBuilder.append(":shortest=1");
                    }
                    stringBuilder.append("[outv").append(i).append("];");
                }
            }
            for (i = 0; i < epVideos.size(); ++i) {
                stringBuilder.append("[outv").append(i).append("]");
            }
            stringBuilder.append("concat=n=").append(epVideos.size()).append(":v=1:a=0[outv]");
            if (!isNoAudioTrack) {
                stringBuilder.append(";");
                for (i = 0; i < epVideos.size(); ++i) {
                    stringBuilder.append("[").append(i).append(":a]");
                }
                stringBuilder.append("concat=n=").append(epVideos.size()).append(":v=0:a=1[outa]");
            }
            if (!stringBuilder.toString().equals("")) {
                cmd.append(stringBuilder.toString());
            }
            cmd.append("-map").append("[outv]");
            if (!isNoAudioTrack) {
                cmd.append("-map").append("[outa]");
            }
            cmd.append(outputOption.getOutputInfo().split(" "));
            cmd.append("-preset").append("superfast").append(outputOption.outPath);
            duration = 0L;
            for (EpVideo ep : epVideos) {
                long d = VideoUitls.getDuration(ep.getVideoPath());
                if (ep.getVideoClip()) {
                    long clipTime = (long)((ep.getClipDuration() - ep.getClipStart()) * 1000000.0f);
                    long l = d = clipTime < d ? clipTime : d;
                }
                if (d == 0L) break;
                duration += d;
            }
        } else {
            throw new RuntimeException("Need more than one video");
        }
        EpEditor.execCmd(cmd, duration, onEditorListener);
    }

    public static void mergeByLc(Context context, List<EpVideo> epVideos, OutputOption outputOption, OnEditorListener onEditorListener) {
        EpVideo ep;
        long d;
        String appDir = context.getCacheDir().getAbsolutePath() + "/EpVideos/";
        String fileName = "ffmpeg_concat.txt";
        ArrayList<String> videos = new ArrayList<String>();
        for (EpVideo e : epVideos) {
            videos.add(e.getVideoPath());
        }
        FileUtils.writeTxtToFile(videos, appDir, fileName);
        CmdList cmd = new CmdList();
        cmd.append("ffmpeg").append("-y").append("-f").append("concat").append("-safe").append("0").append("-i").append(appDir + fileName).append("-c").append("copy").append(outputOption.outPath);
        long duration = 0L;
        Iterator<EpVideo> iterator = epVideos.iterator();
        while (iterator.hasNext() && (d = VideoUitls.getDuration((ep = iterator.next()).getVideoPath())) != 0L) {
            duration += d;
        }
        EpEditor.execCmd(cmd, duration, onEditorListener);
    }

    public static void music(String videoin, String audioin, String output, float videoVolume, float audioVolume, OnEditorListener onEditorListener) {
        MediaExtractor mediaExtractor = new MediaExtractor();
        try {
            mediaExtractor.setDataSource(videoin);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int at = TrackUtils.selectAudioTrack(mediaExtractor);
        CmdList cmd = new CmdList();
        cmd.append("ffmpeg").append("-y").append("-i").append(videoin);
        if (at == -1) {
            int vt = TrackUtils.selectVideoTrack(mediaExtractor);
            float duration = (float)mediaExtractor.getTrackFormat(vt).getLong("durationUs") / 1000.0f / 1000.0f;
            cmd.append("-ss").append("0").append("-t").append(duration).append("-i").append(audioin).append("-acodec").append("copy").append("-vcodec").append("copy");
        } else {
            cmd.append("-i").append(audioin).append("-filter_complex").append("[0:a]aformat=sample_fmts=fltp:sample_rates=44100:channel_layouts=stereo,volume=" + videoVolume + "[a0];[1:a]aformat=sample_fmts=fltp:sample_rates=44100:channel_layouts=stereo,volume=" + audioVolume + "[a1];[a0][a1]amix=inputs=2:duration=first[aout]").append("-map").append("[aout]").append("-ac").append("2").append("-c:v").append("copy").append("-map").append("0:v:0");
        }
        cmd.append(output);
        mediaExtractor.release();
        long d = VideoUitls.getDuration(videoin);
        EpEditor.execCmd(cmd, d, onEditorListener);
    }

    public static void demuxer(String videoin, String out, Format format, OnEditorListener onEditorListener) {
        CmdList cmd = new CmdList();
        cmd.append("ffmpeg").append("-y").append("-i").append(videoin);
        switch (format) {
            case MP3: {
                cmd.append("-vn").append("-acodec").append("libmp3lame");
                break;
            }
            case MP4: {
                cmd.append("-vcodec").append("copy").append("-an");
            }
        }
        cmd.append(out);
        long d = VideoUitls.getDuration(videoin);
        EpEditor.execCmd(cmd, d, onEditorListener);
    }

    public static void reverse(String videoin, String out, boolean vr, boolean ar, OnEditorListener onEditorListener) {
        if (!vr && !ar) {
            Log.e((String)"ffmpeg", (String)"parameter error");
            onEditorListener.onFailure();
            return;
        }
        CmdList cmd = new CmdList();
        cmd.append("ffmpeg").append("-y").append("-i").append(videoin).append("-filter_complex");
        String filter = "";
        if (vr) {
            filter = filter + "[0:v]reverse[v];";
        }
        if (ar) {
            filter = filter + "[0:a]areverse[a];";
        }
        cmd.append(filter.substring(0, filter.length() - 1));
        if (vr) {
            cmd.append("-map").append("[v]");
        }
        if (ar) {
            cmd.append("-map").append("[a]");
        }
        if (ar && !vr) {
            cmd.append("-acodec").append("libmp3lame");
        }
        cmd.append("-preset").append("superfast").append(out);
        long d = VideoUitls.getDuration(videoin);
        EpEditor.execCmd(cmd, d, onEditorListener);
    }

    public static void changePTS(String videoin, String out, float times, PTS pts, OnEditorListener onEditorListener) {
        if (times < 0.25f || times > 4.0f) {
            Log.e((String)"ffmpeg", (String)"times can only be 0.25 to 4");
            onEditorListener.onFailure();
            return;
        }
        CmdList cmd = new CmdList();
        cmd.append("ffmpeg").append("-y").append("-i").append(videoin);
        String t = "atempo=" + times;
        if (times < 0.5f) {
            t = "atempo=0.5,atempo=" + times / 0.5f;
        } else if (times > 2.0f) {
            t = "atempo=2.0,atempo=" + times / 2.0f;
        }
        Log.v((String)"ffmpeg", (String)("atempo:" + t));
        switch (pts) {
            case VIDEO: {
                cmd.append("-filter_complex").append("[0:v]setpts=" + 1.0f / times + "*PTS").append("-an");
                break;
            }
            case AUDIO: {
                cmd.append("-filter:a").append(t);
                break;
            }
            case ALL: {
                cmd.append("-filter_complex").append("[0:v]setpts=" + 1.0f / times + "*PTS[v];[0:a]" + t + "[a]").append("-map").append("[v]").append("-map").append("[a]");
            }
        }
        cmd.append("-preset").append("superfast").append(out);
        long d = VideoUitls.getDuration(videoin);
        double dd = (float)d / times;
        long ddd = (long)dd;
        EpEditor.execCmd(cmd, ddd, onEditorListener);
    }

    public static void video2pic(String videoin, String out, int w, int h, float rate, OnEditorListener onEditorListener) {
        if (w <= 0 || h <= 0) {
            Log.e((String)"ffmpeg", (String)"width and height must greater than 0");
            onEditorListener.onFailure();
            return;
        }
        if (rate <= 0.0f) {
            Log.e((String)"ffmpeg", (String)"rate must greater than 0");
            onEditorListener.onFailure();
            return;
        }
        CmdList cmd = new CmdList();
        cmd.append("ffmpeg").append("-y").append("-i").append(videoin).append("-r").append(rate).append("-s").append(w + "x" + h).append("-q:v").append(2).append("-f").append("image2").append("-preset").append("superfast").append(out);
        long d = VideoUitls.getDuration(videoin);
        EpEditor.execCmd(cmd, d, onEditorListener);
    }

    public static void pic2video(String videoin, String out, int w, int h, float rate, OnEditorListener onEditorListener) {
        if (w < 0 || h < 0) {
            Log.e((String)"ffmpeg", (String)"width and height must greater than 0");
            onEditorListener.onFailure();
            return;
        }
        if (rate <= 0.0f) {
            Log.e((String)"ffmpeg", (String)"rate must greater than 0");
            onEditorListener.onFailure();
            return;
        }
        CmdList cmd = new CmdList();
        cmd.append("ffmpeg").append("-y").append("-f").append("image2").append("-i").append(videoin).append("-vcodec").append("libx264").append("-r").append(rate);
        if (w > 0 && h > 0) {
            cmd.append("-s").append(w + "x" + h);
        }
        cmd.append(out);
        long d = VideoUitls.getDuration(videoin);
        EpEditor.execCmd(cmd, d, onEditorListener);
    }

    public static void execCmd(String cmd, long duration, final OnEditorListener onEditorListener) {
        cmd = "ffmpeg " + cmd;
        String[] cmds = cmd.split(" ");
        FFmpegCmd.exec(cmds, duration, new OnEditorListener(){

            @Override
            public void onSuccess() {
                onEditorListener.onSuccess();
            }

            @Override
            public void onFailure() {
                onEditorListener.onFailure();
            }

            @Override
            public void onProgress(float progress) {
                onEditorListener.onProgress(progress);
            }
        });
    }

    private static void execCmd(CmdList cmd, long duration, final OnEditorListener onEditorListener) {
        String[] cmds = cmd.toArray(new String[cmd.size()]);
        String cmdLog = "";
        for (String ss : cmds) {
            cmdLog = cmdLog + cmds;
        }
        Log.v((String)"EpMediaF", (String)("cmd:" + cmdLog));
        FFmpegCmd.exec(cmds, duration, new OnEditorListener(){

            @Override
            public void onSuccess() {
                onEditorListener.onSuccess();
            }

            @Override
            public void onFailure() {
                onEditorListener.onFailure();
            }

            @Override
            public void onProgress(float progress) {
                onEditorListener.onProgress(progress);
            }
        });
    }

    public static class OutputOption {
        static final int ONE_TO_ONE = 1;
        static final int FOUR_TO_THREE = 2;
        static final int SIXTEEN_TO_NINE = 3;
        static final int NINE_TO_SIXTEEN = 4;
        static final int THREE_TO_FOUR = 5;
        String outPath;
        public int frameRate = 0;
        public int bitRate = 0;
        public String outFormat = "";
        private int width = 0;
        private int height = 0;
        private int sar = 6;

        public OutputOption(String outPath) {
            this.outPath = outPath;
        }

        public String getSar() {
            String res;
            switch (this.sar) {
                case 1: {
                    res = "1/1";
                    break;
                }
                case 2: {
                    res = "4/3";
                    break;
                }
                case 5: {
                    res = "3/4";
                    break;
                }
                case 3: {
                    res = "16/9";
                    break;
                }
                case 4: {
                    res = "9/16";
                    break;
                }
                default: {
                    res = this.width + "/" + this.height;
                }
            }
            return res;
        }

        public void setSar(int sar) {
            this.sar = sar;
        }

        String getOutputInfo() {
            StringBuilder res = new StringBuilder();
            if (this.frameRate != 0) {
                res.append(" -r ").append(this.frameRate);
            }
            if (this.bitRate != 0) {
                res.append(" -b ").append(this.bitRate).append("M");
            }
            if (!this.outFormat.isEmpty()) {
                res.append(" -f ").append(this.outFormat);
            }
            return res.toString();
        }

        public void setWidth(int width) {
            if (width % 2 != 0) {
                --width;
            }
            this.width = width;
        }

        public void setHeight(int height) {
            if (height % 2 != 0) {
                --height;
            }
            this.height = height;
        }
    }

    public static enum PTS {
        VIDEO,
        AUDIO,
        ALL;

    }

    public static enum Format {
        MP3,
        MP4;

    }
}

