/*
 * Decompiled with CFR 0.152.
 */
package VideoHandle;

import VideoHandle.EpDraw;
import VideoHandle.EpText;
import java.util.ArrayList;

public class EpVideo {
    private String videoPath;
    private boolean isClip = false;
    private float clipStart;
    private float clipDuration;
    private StringBuilder filter;
    private ArrayList<EpDraw> epPics;
    private Crop mCrop;

    public EpVideo(String videoPath) {
        this.videoPath = videoPath;
        this.epPics = new ArrayList();
    }

    private StringBuilder getFilter() {
        if (this.filter == null || this.filter.toString().equals("")) {
            this.filter = new StringBuilder();
        } else {
            this.filter.append(",");
        }
        return this.filter;
    }

    public StringBuilder getFilters() {
        return this.filter;
    }

    public String getVideoPath() {
        return this.videoPath;
    }

    public boolean getVideoClip() {
        return this.isClip;
    }

    public float getClipStart() {
        return this.clipStart;
    }

    public float getClipDuration() {
        return this.clipDuration;
    }

    public EpVideo clip(float start, float duration) {
        this.isClip = true;
        this.clipStart = start;
        this.clipDuration = duration;
        return this;
    }

    public EpVideo rotation(int rotation, boolean isFlip) {
        this.filter = this.getFilter();
        if (isFlip) {
            switch (rotation) {
                case 0: {
                    this.filter.append("hflip");
                    break;
                }
                case 90: {
                    this.filter.append("transpose=3");
                    break;
                }
                case 180: {
                    this.filter.append("vflip");
                    break;
                }
                case 270: {
                    this.filter.append("transpose=0");
                }
            }
        } else {
            switch (rotation) {
                case 90: {
                    this.filter.append("transpose=2");
                    break;
                }
                case 180: {
                    this.filter.append("vflip,hflip");
                    break;
                }
                case 270: {
                    this.filter.append("transpose=1");
                }
            }
        }
        return this;
    }

    public EpVideo crop(float width, float height, float x, float y) {
        this.filter = this.getFilter();
        this.mCrop = new Crop(width, height, x, y);
        this.filter.append("crop=" + width + ":" + height + ":" + x + ":" + y);
        return this;
    }

    public Crop getCrop() {
        return this.mCrop;
    }

    @Deprecated
    public EpVideo addText(int x, int y, float size, String color, String ttf, String text) {
        this.filter = this.getFilter();
        this.filter.append("drawtext=fontfile=" + ttf + ":fontsize=" + size + ":fontcolor=" + color + ":x=" + x + ":y=" + y + ":text='" + text + "'");
        return this;
    }

    public EpVideo addText(EpText epText) {
        this.filter = this.getFilter();
        this.filter.append(epText.getTextFitler());
        return this;
    }

    public EpVideo addTime(int x, int y, float size, String color, String ttf, int type) {
        long time = System.currentTimeMillis() / 1000L;
        String str = String.valueOf(time);
        this.filter = this.getFilter();
        String ts = "";
        switch (type) {
            case 1: {
                ts = "%{pts\\:localtime\\:" + str + "\\:%H\\\\\\:%M\\\\\\:%S}";
                break;
            }
            case 2: {
                ts = "%{pts\\:localtime\\:" + str + "}";
                break;
            }
            case 3: {
                ts = "%{pts\\:localtime\\:" + str + "\\:%Y\\\\\u5e74%m\\\\\u6708%d\\\\\u65e5\n%H\\\\\\\u65f6%M\\\\\\\u5206%S\u79d2}";
            }
        }
        this.filter.append("drawtext=fontfile=" + ttf + ":fontsize=" + size + ":fontcolor=" + color + ":x=" + x + ":y=" + y + ":text='" + ts + "'");
        return this;
    }

    public EpVideo addFilter(String ofi) {
        this.filter = this.getFilter();
        this.filter.append(ofi);
        return this;
    }

    public EpVideo addDraw(EpDraw epDraw) {
        this.epPics.add(epDraw);
        return this;
    }

    public ArrayList<EpDraw> getEpDraws() {
        return this.epPics;
    }

    public class Crop {
        float width;
        float height;
        float x;
        float y;

        public Crop(float width, float height, float x, float y) {
            this.width = width;
            this.height = height;
            this.x = x;
            this.y = y;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }
    }
}

