/*
 * Decompiled with CFR 0.152.
 */
package com.mobile.ffmpeg;

import com.arthenica.mobileffmpeg.AbiDetect;
import com.arthenica.mobileffmpeg.Config;
import java.util.ArrayList;

public class FFmpeg {
    private FFmpeg() {
    }

    public static int execute(String[] arguments) {
        int lastReturnCode = Config.nativeFFmpegExecute(arguments);
        Config.setLastReturnCode(lastReturnCode);
        return lastReturnCode;
    }

    public static int execute(String command, String delimiter) {
        String[] stringArray;
        if (command == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = command.split(delimiter == null ? " " : delimiter);
        }
        return FFmpeg.execute(stringArray);
    }

    public static int execute(String command) {
        return FFmpeg.execute(FFmpeg.parseArguments(command));
    }

    public static void cancel() {
        Config.nativeFFmpegCancel();
    }

    static String[] parseArguments(String command) {
        ArrayList<String> argumentList = new ArrayList<String>();
        StringBuilder currentArgument = new StringBuilder();
        boolean singleQuoteStarted = false;
        boolean doubleQuoteStarted = false;
        for (int i = 0; i < command.length(); ++i) {
            Character previousChar = i > 0 ? Character.valueOf(command.charAt(i - 1)) : null;
            char currentChar = command.charAt(i);
            if (currentChar == ' ') {
                if (singleQuoteStarted || doubleQuoteStarted) {
                    currentArgument.append(currentChar);
                    continue;
                }
                if (currentArgument.length() <= 0) continue;
                argumentList.add(currentArgument.toString());
                currentArgument = new StringBuilder();
                continue;
            }
            if (currentChar == '\'' && (previousChar == null || previousChar.charValue() != '\\')) {
                if (singleQuoteStarted) {
                    singleQuoteStarted = false;
                    continue;
                }
                if (doubleQuoteStarted) {
                    currentArgument.append(currentChar);
                    continue;
                }
                singleQuoteStarted = true;
                continue;
            }
            if (currentChar == '\"' && (previousChar == null || previousChar.charValue() != '\\')) {
                if (doubleQuoteStarted) {
                    doubleQuoteStarted = false;
                    continue;
                }
                if (singleQuoteStarted) {
                    currentArgument.append(currentChar);
                    continue;
                }
                doubleQuoteStarted = true;
                continue;
            }
            currentArgument.append(currentChar);
        }
        if (currentArgument.length() > 0) {
            argumentList.add(currentArgument.toString());
        }
        return argumentList.toArray(new String[0]);
    }

    static {
        AbiDetect.class.getName();
        Config.class.getName();
    }
}

