/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.mobileffmpeg;

import android.os.Build;
import com.arthenica.mobileffmpeg.Config;
import com.mobile.ffmpeg.FFmpeg;

public class AbiDetect {
    static final String ARM_V7A = "arm-v7a";
    static final String ARM_V7A_NEON = "arm-v7a-neon";
    private static boolean armV7aNeonLoaded = false;

    private AbiDetect() {
    }

    static void setArmV7aNeonLoaded(boolean armV7aNeonLoaded) {
        AbiDetect.armV7aNeonLoaded = armV7aNeonLoaded;
    }

    public static String getAbi() {
        if (armV7aNeonLoaded) {
            return ARM_V7A_NEON;
        }
        return AbiDetect.getNativeAbi();
    }

    public static native String getNativeAbi();

    public static native String getNativeCpuAbi();

    static native boolean isNativeLTSBuild();

    public static native String getNativeBuildConf();

    static {
        if (Build.VERSION.SDK_INT < 21) {
            System.loadLibrary("cpufeatures");
        }
        System.loadLibrary("mobileffmpeg_abidetect");
        Config.class.getName();
        FFmpeg.class.getName();
    }
}

