/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.task;

import com.ironz.binaryprefs.event.ExceptionHandler;
import com.ironz.binaryprefs.task.FutureBarrier;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public final class ScheduledBackgroundTaskExecutor
implements TaskExecutor {
    private static final int THREADS_COUNT = 1;
    private static final String THREAD_NAME_PREFIX = "binaryprefs-pool-%s";
    private final ExceptionHandler exceptionHandler;
    private final ExecutorService currentExecutor;

    public ScheduledBackgroundTaskExecutor(String prefName, ExceptionHandler exceptionHandler, Map<String, ExecutorService> executors) {
        this.exceptionHandler = exceptionHandler;
        this.currentExecutor = this.putIfAbsentExecutor(prefName, executors);
    }

    private ExecutorService putIfAbsentExecutor(String prefName, Map<String, ExecutorService> executors) {
        if (executors.containsKey(prefName)) {
            return executors.get(prefName);
        }
        ThreadFactory factory = this.createThreadFactory(prefName);
        ExecutorService service = Executors.newFixedThreadPool(1, factory);
        executors.put(prefName, service);
        return service;
    }

    private ThreadFactory createThreadFactory(final String prefName) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return ScheduledBackgroundTaskExecutor.this.createThread(r, prefName);
            }
        };
    }

    private Thread createThread(Runnable r, String prefName) {
        Thread thread = new Thread(r);
        thread.setName(String.format(THREAD_NAME_PREFIX, prefName));
        thread.setPriority(10);
        return thread;
    }

    @Override
    public FutureBarrier<?> submit(Runnable runnable) {
        Future<?> submit = this.currentExecutor.submit(runnable);
        return new FutureBarrier(submit, this.exceptionHandler);
    }

    @Override
    public <T> FutureBarrier<T> submit(Callable<T> callable) {
        Future<T> submit = this.currentExecutor.submit(callable);
        return new FutureBarrier<T>(submit, this.exceptionHandler);
    }
}

