/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.lock;

import com.ironz.binaryprefs.file.directory.DirectoryProvider;
import com.ironz.binaryprefs.lock.LockFactory;
import com.ironz.binaryprefs.lock.ProcessFileLock;
import java.io.File;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class SimpleLockFactory
implements LockFactory {
    private static final String LOCK_EXTENSION = ".lock";
    private final File lockDirectory;
    private final ReadWriteLock readWriteLock;
    private final Lock processLock;

    public SimpleLockFactory(String prefName, DirectoryProvider provider, Map<String, ReadWriteLock> locks, Map<String, Lock> processLocks) {
        this.lockDirectory = provider.getLockDirectory();
        this.readWriteLock = this.putIfAbsentLocalLock(prefName, locks);
        this.processLock = this.putIfAbsentProcessLock(prefName, processLocks);
    }

    private ReadWriteLock putIfAbsentLocalLock(String name, Map<String, ReadWriteLock> locks) {
        if (locks.containsKey(name)) {
            return locks.get(name);
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        locks.put(name, lock);
        return lock;
    }

    private Lock putIfAbsentProcessLock(String name, Map<String, Lock> processLocks) {
        if (processLocks.containsKey(name)) {
            return processLocks.get(name);
        }
        File file = new File(this.lockDirectory, name + LOCK_EXTENSION);
        ProcessFileLock lock = new ProcessFileLock(file);
        processLocks.put(name, lock);
        return lock;
    }

    @Override
    public Lock getReadLock() {
        return this.readWriteLock.readLock();
    }

    @Override
    public Lock getWriteLock() {
        return this.readWriteLock.writeLock();
    }

    @Override
    public Lock getProcessLock() {
        return this.processLock;
    }
}

