/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.cache.candidates;

import com.ironz.binaryprefs.cache.candidates.CacheCandidateProvider;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public final class ConcurrentCacheCandidateProvider
implements CacheCandidateProvider {
    private final Set<String> currentCandidates;

    public ConcurrentCacheCandidateProvider(String prefName, Map<String, Set<String>> allCacheCandidates) {
        this.currentCandidates = this.putIfAbsentCache(prefName, allCacheCandidates);
    }

    private Set<String> putIfAbsentCache(String prefName, Map<String, Set<String>> allCacheCandidates) {
        if (allCacheCandidates.containsKey(prefName)) {
            return allCacheCandidates.get(prefName);
        }
        ConcurrentSkipListSet<String> set = new ConcurrentSkipListSet<String>();
        allCacheCandidates.put(prefName, set);
        return set;
    }

    @Override
    public boolean contains(String key) {
        return this.currentCandidates.contains(key);
    }

    @Override
    public void put(String key) {
        this.currentCandidates.add(key);
    }

    @Override
    public Set<String> keys() {
        return Collections.unmodifiableSet(this.currentCandidates);
    }

    @Override
    public void remove(String key) {
        this.currentCandidates.remove(key);
    }
}

