/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Looper;
import com.ironz.binaryprefs.BinaryPreferences;
import com.ironz.binaryprefs.ParametersProvider;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.cache.candidates.ConcurrentCacheCandidateProvider;
import com.ironz.binaryprefs.cache.provider.ConcurrentCacheProvider;
import com.ironz.binaryprefs.encryption.KeyEncryption;
import com.ironz.binaryprefs.encryption.ValueEncryption;
import com.ironz.binaryprefs.event.BroadcastEventBridge;
import com.ironz.binaryprefs.event.EventBridge;
import com.ironz.binaryprefs.event.ExceptionHandler;
import com.ironz.binaryprefs.event.MainThreadEventBridge;
import com.ironz.binaryprefs.exception.PreferencesInitializationException;
import com.ironz.binaryprefs.fetch.EagerFetchStrategy;
import com.ironz.binaryprefs.fetch.FetchStrategy;
import com.ironz.binaryprefs.fetch.LazyFetchStrategy;
import com.ironz.binaryprefs.file.adapter.NioFileAdapter;
import com.ironz.binaryprefs.file.directory.AndroidDirectoryProvider;
import com.ironz.binaryprefs.file.transaction.MultiProcessTransaction;
import com.ironz.binaryprefs.lock.SimpleLockFactory;
import com.ironz.binaryprefs.migration.MigrateProcessor;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.serialization.serializer.persistable.PersistableRegistry;
import com.ironz.binaryprefs.task.ScheduledBackgroundTaskExecutor;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public final class BinaryPreferencesBuilder {
    public static final String DEFAULT_NAME = "default";
    private static final String INCORRECT_THREAD_INIT_MESSAGE = "Preferences should be instantiated in the main thread.";
    private final ParametersProvider parametersProvider = new ParametersProvider();
    private final Map<String, ReadWriteLock> locks = this.parametersProvider.getLocks();
    private final Map<String, Lock> processLocks = this.parametersProvider.getProcessLocks();
    private final Map<String, ExecutorService> executors = this.parametersProvider.getExecutors();
    private final Map<String, Map<String, Object>> caches = this.parametersProvider.getCaches();
    private final Map<String, Set<String>> cacheCandidates = this.parametersProvider.getCacheCandidates();
    private final Map<String, List<SharedPreferences.OnSharedPreferenceChangeListener>> allListeners = this.parametersProvider.getAllListeners();
    private final Context context;
    private final PersistableRegistry persistableRegistry = new PersistableRegistry();
    private final MigrateProcessor migrateProcessor = new MigrateProcessor();
    private File baseDir;
    private String name = "default";
    private boolean supportInterProcess = false;
    private boolean allowBuildOnBackgroundThread = false;
    private MemoryCacheMode memoryCacheMode = MemoryCacheMode.LAZY;
    private KeyEncryption keyEncryption = KeyEncryption.NO_OP;
    private ValueEncryption valueEncryption = ValueEncryption.NO_OP;
    private ExceptionHandler exceptionHandler = ExceptionHandler.PRINT;

    public BinaryPreferencesBuilder(Context context) {
        this.context = context;
        this.baseDir = context.getFilesDir();
    }

    public BinaryPreferencesBuilder name(String name) {
        this.name = name;
        return this;
    }

    public BinaryPreferencesBuilder externalStorage(boolean value) {
        this.baseDir = value ? this.context.getExternalFilesDir(null) : this.context.getFilesDir();
        return this;
    }

    public BinaryPreferencesBuilder customDirectory(File baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public BinaryPreferencesBuilder supportInterProcess(boolean value) {
        this.supportInterProcess = value;
        return this;
    }

    public BinaryPreferencesBuilder memoryCacheMode(MemoryCacheMode mode) {
        this.memoryCacheMode = mode;
        return this;
    }

    public BinaryPreferencesBuilder keyEncryption(KeyEncryption keyEncryption) {
        this.keyEncryption = keyEncryption;
        return this;
    }

    public BinaryPreferencesBuilder valueEncryption(ValueEncryption valueEncryption) {
        this.valueEncryption = valueEncryption;
        return this;
    }

    public BinaryPreferencesBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public BinaryPreferencesBuilder registerPersistable(String key, Class<? extends Persistable> persistable) {
        this.persistableRegistry.register(key, persistable);
        return this;
    }

    public BinaryPreferencesBuilder migrateFrom(SharedPreferences preferences) {
        this.migrateProcessor.add(preferences);
        return this;
    }

    public BinaryPreferencesBuilder allowBuildOnBackgroundThread() {
        this.allowBuildOnBackgroundThread = true;
        return this;
    }

    public Preferences build() {
        if (!this.allowBuildOnBackgroundThread && Looper.myLooper() != Looper.getMainLooper()) {
            throw new PreferencesInitializationException(INCORRECT_THREAD_INIT_MESSAGE);
        }
        BinaryPreferences preferences = this.createInstance();
        this.migrateProcessor.migrateTo(preferences);
        return preferences;
    }

    private BinaryPreferences createInstance() {
        AndroidDirectoryProvider directoryProvider = new AndroidDirectoryProvider(this.name, this.baseDir);
        NioFileAdapter fileAdapter = new NioFileAdapter(directoryProvider);
        SimpleLockFactory lockFactory = new SimpleLockFactory(this.name, directoryProvider, this.locks, this.processLocks);
        MultiProcessTransaction fileTransaction = new MultiProcessTransaction(fileAdapter, lockFactory, this.keyEncryption, this.valueEncryption);
        ConcurrentCacheCandidateProvider cacheCandidateProvider = new ConcurrentCacheCandidateProvider(this.name, this.cacheCandidates);
        ConcurrentCacheProvider cacheProvider = new ConcurrentCacheProvider(this.name, this.caches);
        ScheduledBackgroundTaskExecutor taskExecutor = new ScheduledBackgroundTaskExecutor(this.name, this.exceptionHandler, this.executors);
        SerializerFactory serializerFactory = new SerializerFactory(this.persistableRegistry);
        EventBridge eventsBridge = this.supportInterProcess ? new BroadcastEventBridge(this.context, this.name, cacheCandidateProvider, cacheProvider, serializerFactory, taskExecutor, this.valueEncryption, directoryProvider, this.allListeners) : new MainThreadEventBridge(this.name, this.allListeners);
        FetchStrategy strategy = this.memoryCacheMode == MemoryCacheMode.LAZY ? new LazyFetchStrategy(lockFactory, taskExecutor, cacheCandidateProvider, cacheProvider, fileTransaction, serializerFactory) : new EagerFetchStrategy(lockFactory, taskExecutor, cacheCandidateProvider, cacheProvider, fileTransaction, serializerFactory);
        return new BinaryPreferences(fileTransaction, eventsBridge, cacheCandidateProvider, cacheProvider, taskExecutor, serializerFactory, lockFactory, strategy);
    }

    public static enum MemoryCacheMode {
        LAZY,
        EAGER;

    }
}

