/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs;

import android.content.SharedPreferences;
import com.ironz.binaryprefs.BinaryPreferencesEditor;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.PreferencesEditor;
import com.ironz.binaryprefs.cache.candidates.CacheCandidateProvider;
import com.ironz.binaryprefs.cache.provider.CacheProvider;
import com.ironz.binaryprefs.event.EventBridge;
import com.ironz.binaryprefs.event.OnSharedPreferenceChangeListenerWrapper;
import com.ironz.binaryprefs.fetch.FetchStrategy;
import com.ironz.binaryprefs.file.transaction.FileTransaction;
import com.ironz.binaryprefs.lock.LockFactory;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

final class BinaryPreferences
implements Preferences {
    private final FileTransaction fileTransaction;
    private final EventBridge eventsBridge;
    private final CacheCandidateProvider cacheCandidateProvider;
    private final CacheProvider cacheProvider;
    private final TaskExecutor taskExecutor;
    private final SerializerFactory serializerFactory;
    private final Lock readLock;
    private final Lock writeLock;
    private final FetchStrategy fetchStrategy;

    BinaryPreferences(FileTransaction fileTransaction, EventBridge eventsBridge, CacheCandidateProvider cacheCandidateProvider, CacheProvider cacheProvider, TaskExecutor taskExecutor, SerializerFactory serializerFactory, LockFactory lockFactory, FetchStrategy fetchStrategy) {
        this.fileTransaction = fileTransaction;
        this.eventsBridge = eventsBridge;
        this.cacheCandidateProvider = cacheCandidateProvider;
        this.cacheProvider = cacheProvider;
        this.taskExecutor = taskExecutor;
        this.serializerFactory = serializerFactory;
        this.readLock = lockFactory.getReadLock();
        this.writeLock = lockFactory.getWriteLock();
        this.fetchStrategy = fetchStrategy;
    }

    public Map<String, Object> getAll() {
        return this.fetchStrategy.getAll();
    }

    public String getString(String key, String defValue) {
        return (String)this.fetchStrategy.getValue(key, defValue);
    }

    public Set<String> getStringSet(String key, Set<String> defValue) {
        return (Set)this.fetchStrategy.getValue(key, defValue);
    }

    public int getInt(String key, int defValue) {
        return (Integer)this.fetchStrategy.getValue(key, defValue);
    }

    public long getLong(String key, long defValue) {
        return (Long)this.fetchStrategy.getValue(key, defValue);
    }

    public float getFloat(String key, float defValue) {
        return ((Float)this.fetchStrategy.getValue(key, Float.valueOf(defValue))).floatValue();
    }

    public boolean getBoolean(String key, boolean defValue) {
        return (Boolean)this.fetchStrategy.getValue(key, defValue);
    }

    @Override
    public <T extends Persistable> T getPersistable(String key, T defValue) {
        return (T)((Persistable)this.fetchStrategy.getValue(key, defValue));
    }

    @Override
    public byte getByte(String key, byte defValue) {
        return (Byte)this.fetchStrategy.getValue(key, defValue);
    }

    @Override
    public short getShort(String key, short defValue) {
        return (Short)this.fetchStrategy.getValue(key, defValue);
    }

    @Override
    public char getChar(String key, char defValue) {
        return ((Character)this.fetchStrategy.getValue(key, Character.valueOf(defValue))).charValue();
    }

    @Override
    public double getDouble(String key, double defValue) {
        return (Double)this.fetchStrategy.getValue(key, defValue);
    }

    @Override
    public byte[] getByteArray(String key, byte[] defValue) {
        return (byte[])this.fetchStrategy.getValue(key, defValue);
    }

    public boolean contains(String key) {
        return this.fetchStrategy.contains(key);
    }

    @Override
    public PreferencesEditor edit() {
        return this.editInternal();
    }

    private PreferencesEditor editInternal() {
        this.readLock.lock();
        try {
            BinaryPreferencesEditor binaryPreferencesEditor = new BinaryPreferencesEditor(this.fileTransaction, this.eventsBridge, this.taskExecutor, this.serializerFactory, this.cacheProvider, this.cacheCandidateProvider, this.writeLock);
            return binaryPreferencesEditor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<String> keys() {
        this.readLock.lock();
        try {
            Set<String> set = this.cacheProvider.keys();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.writeLock.lock();
        try {
            OnSharedPreferenceChangeListenerWrapper wrapper = new OnSharedPreferenceChangeListenerWrapper(this, listener);
            this.eventsBridge.registerOnSharedPreferenceChangeListener(wrapper);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.writeLock.lock();
        try {
            OnSharedPreferenceChangeListenerWrapper wrapper = new OnSharedPreferenceChangeListenerWrapper(this, listener);
            this.eventsBridge.unregisterOnSharedPreferenceChangeListener(wrapper);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

