/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.cache.provider;

import com.ironz.binaryprefs.cache.provider.CacheProvider;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ConcurrentCacheProvider
implements CacheProvider {
    private final Map<String, Object> currentCache;

    public ConcurrentCacheProvider(String prefName, Map<String, Map<String, Object>> allCaches) {
        this.currentCache = this.putIfAbsentCache(prefName, allCaches);
    }

    private Map<String, Object> putIfAbsentCache(String prefName, Map<String, Map<String, Object>> allCaches) {
        if (allCaches.containsKey(prefName)) {
            return allCaches.get(prefName);
        }
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        allCaches.put(prefName, map);
        return map;
    }

    @Override
    public boolean contains(String key) {
        return this.currentCache.containsKey(key);
    }

    @Override
    public void put(String key, Object value) {
        this.currentCache.put(key, value);
    }

    @Override
    public Set<String> keys() {
        Set<String> s = this.currentCache.keySet();
        return Collections.unmodifiableSet(s);
    }

    @Override
    public Object get(String key) {
        return this.currentCache.get(key);
    }

    @Override
    public void remove(String key) {
        this.currentCache.remove(key);
    }

    @Override
    public Map<String, Object> getAll() {
        return this.currentCache;
    }
}

