/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.task;

import com.ironz.binaryprefs.exception.ExceptionHandler;
import com.ironz.binaryprefs.task.Completable;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class ScheduledBackgroundTaskExecutor
implements TaskExecutor {
    private static final int THREADS_COUNT = 1;
    private static final String THREAD_NAME_PREFIX = "binaryprefs-pool-%s-%s";
    private static final Map<String, ExecutorService> executors = new ConcurrentHashMap<String, ExecutorService>();
    private static final AtomicInteger threadId = new AtomicInteger();
    private final ExceptionHandler handler;
    private final ExecutorService currentExecutor;

    public ScheduledBackgroundTaskExecutor(String prefName, ExceptionHandler handler) {
        this.handler = handler;
        this.currentExecutor = this.createExecutor(prefName);
    }

    private ExecutorService createExecutor(String prefName) {
        if (executors.containsKey(prefName)) {
            return executors.get(prefName);
        }
        ThreadFactory factory = this.createThreadFactory(prefName);
        ExecutorService service = Executors.newFixedThreadPool(1, factory);
        executors.put(prefName, service);
        return service;
    }

    private ThreadFactory createThreadFactory(final String prefName) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return ScheduledBackgroundTaskExecutor.this.createThread(r, prefName);
            }
        };
    }

    private Thread createThread(Runnable r, String prefName) {
        Thread thread = new Thread(r);
        thread.setName(String.format(THREAD_NAME_PREFIX, prefName, threadId.incrementAndGet()));
        thread.setPriority(10);
        return thread;
    }

    @Override
    public synchronized Completable submit(Runnable runnable) {
        Future<?> submit = this.currentExecutor.submit(runnable);
        return new Completable(submit, this.handler);
    }
}

