/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.events;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.cache.CacheProvider;
import com.ironz.binaryprefs.encryption.ByteEncryption;
import com.ironz.binaryprefs.events.PreferenceEventBridge;
import java.util.ArrayList;
import java.util.List;

public class BroadcastPreferenceEventBridgeImpl
implements PreferenceEventBridge {
    private static final String ACTION_PREFERENCE_UPDATED = "com.ironz.binaryprefs.ACTION_PREFERENCE_UPDATED";
    private static final String ACTION_PREFERENCE_REMOVED = "com.ironz.binaryprefs.ACTION_PREFERENCE_REMOVED";
    private static final String PREFERENCE_NAME = "preference_name";
    private static final String PREFERENCE_KEY = "preference_update_key";
    private static final String PREFERENCE_VALUE = "preference_update_value";
    private final List<SharedPreferences.OnSharedPreferenceChangeListener> listeners = new ArrayList<SharedPreferences.OnSharedPreferenceChangeListener>();
    private final IntentFilter updateFilter = new IntentFilter("com.ironz.binaryprefs.ACTION_PREFERENCE_UPDATED");
    private final IntentFilter removeFilter = new IntentFilter("com.ironz.binaryprefs.ACTION_PREFERENCE_REMOVED");
    private final BroadcastReceiver updateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BroadcastPreferenceEventBridgeImpl.this.notifyUpdate(intent);
        }
    };
    private final BroadcastReceiver removeReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BroadcastPreferenceEventBridgeImpl.this.notifyRemove(intent);
        }
    };
    private final Context context;
    private final String prefName;
    private final CacheProvider cacheProvider;
    private final ByteEncryption byteEncryption;

    public BroadcastPreferenceEventBridgeImpl(Context context, String prefName, CacheProvider cacheProvider, ByteEncryption byteEncryption) {
        this.context = context;
        this.prefName = prefName;
        this.cacheProvider = cacheProvider;
        this.byteEncryption = byteEncryption;
    }

    private void notifyUpdate(Intent intent) {
        if (!this.prefName.equals(intent.getStringExtra(PREFERENCE_NAME))) {
            return;
        }
        String key = intent.getStringExtra(PREFERENCE_KEY);
        byte[] bytes = intent.getByteArrayExtra(PREFERENCE_VALUE);
        this.notify(key, bytes);
    }

    public void notify(String key, byte[] bytes) {
        byte[] decrypt = this.byteEncryption.decrypt(bytes);
        this.cacheProvider.put(key, decrypt);
        this.notifyListeners(key);
    }

    private void notifyRemove(Intent intent) {
        if (!this.prefName.equals(intent.getStringExtra(PREFERENCE_NAME))) {
            return;
        }
        String key = intent.getStringExtra(PREFERENCE_KEY);
        this.cacheProvider.remove(key);
        this.notifyListeners(key);
    }

    private void notifyListeners(String key) {
        for (SharedPreferences.OnSharedPreferenceChangeListener listener : this.listeners) {
            listener.onSharedPreferenceChanged(null, key);
        }
    }

    @Override
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        if (this.listeners.isEmpty()) {
            this.context.registerReceiver(this.updateReceiver, this.updateFilter);
            this.context.registerReceiver(this.removeReceiver, this.removeFilter);
        }
        this.listeners.add(listener);
    }

    @Override
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.context.unregisterReceiver(this.updateReceiver);
            this.context.unregisterReceiver(this.removeReceiver);
        }
    }

    @Override
    public void notifyListenersUpdate(Preferences preferences, String key, byte[] value) {
        byte[] encrypt = this.byteEncryption.encrypt(value);
        Intent intent = new Intent(ACTION_PREFERENCE_UPDATED);
        intent.putExtra(PREFERENCE_NAME, this.prefName);
        intent.putExtra(PREFERENCE_KEY, key);
        intent.putExtra(PREFERENCE_VALUE, encrypt);
        this.context.sendBroadcast(intent);
    }

    @Override
    public void notifyListenersRemove(Preferences preferences, String key) {
        Intent intent = new Intent(ACTION_PREFERENCE_REMOVED);
        intent.putExtra(PREFERENCE_NAME, this.prefName);
        intent.putExtra(PREFERENCE_KEY, key);
        this.context.sendBroadcast(intent);
    }
}

