/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.encryption;

import com.ironz.binaryprefs.encryption.ByteEncryption;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AesByteEncryptionImpl
implements ByteEncryption {
    private static final String AES = "AES";
    private static final String AES_CBC_PKCS5_PADDING = "AES/CBC/PKCS5PADDING";
    private final Cipher encryptCipher;
    private final Cipher decryptCipher;
    private final Class lock = ByteEncryption.class;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AesByteEncryptionImpl(byte[] secretKeyBytes, byte[] initialVector) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                SecretKeySpec secretKeySpec = new SecretKeySpec(secretKeyBytes, AES);
                IvParameterSpec iv = new IvParameterSpec(initialVector);
                this.encryptCipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
                this.encryptCipher.init(1, (Key)secretKeySpec, iv);
                this.decryptCipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
                this.decryptCipher.init(2, (Key)secretKeySpec, iv);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public byte[] encrypt(byte[] bytes) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.encryptCipher.doFinal(bytes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.decryptCipher.doFinal(bytes);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

