/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs;

import android.content.SharedPreferences;
import com.ironz.binaryprefs.BinaryPreferencesEditor;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.PreferencesEditor;
import com.ironz.binaryprefs.exception.ExceptionHandler;
import com.ironz.binaryprefs.file.FileAdapter;
import com.ironz.binaryprefs.util.Bits;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BinaryPreferences
implements Preferences {
    private final FileAdapter fileAdapter;
    private final ExceptionHandler exceptionHandler;
    private final List<SharedPreferences.OnSharedPreferenceChangeListener> listeners = new ArrayList<SharedPreferences.OnSharedPreferenceChangeListener>();
    private final Class lock = BinaryPreferences.class;

    public BinaryPreferences(FileAdapter fileAdapter, ExceptionHandler exceptionHandler) {
        this.fileAdapter = fileAdapter;
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ?> getAll() {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getAllInternal();
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, "getAll method");
                return new HashMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defValue) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getStringInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getStringSet(String key, Set<String> defValues) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getStringSetInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValues;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key, int defValue) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getIntInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key, long defValue) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getLongInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String key, float defValue) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getFloatInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key, boolean defValue) {
        Class clazz = this.lock;
        synchronized (clazz) {
            try {
                return this.getBooleanInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Externalizable> T getObject(Class<T> clazz, String key, T defValue) {
        Class clazz2 = this.lock;
        synchronized (clazz2) {
            try {
                return this.getObjectInternal(key);
            }
            catch (Exception e) {
                this.exceptionHandler.handle(e, key);
                return defValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        Class clazz = this.lock;
        synchronized (clazz) {
            return this.containsInternal(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreferencesEditor edit() {
        Class clazz = this.lock;
        synchronized (clazz) {
            return new BinaryPreferencesEditor(this.lock, this.fileAdapter, this.exceptionHandler, this.listeners, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Class clazz = this.lock;
        synchronized (clazz) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Class clazz = this.lock;
        synchronized (clazz) {
            this.listeners.remove(listener);
        }
    }

    private Map<String, ?> getAllInternal() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    private String getStringInternal(String key) {
        byte[] bytes = this.fileAdapter.fetch(key);
        return Bits.stringFromBytes(bytes);
    }

    private Set<String> getStringSetInternal(String key) {
        byte[] bytes = this.fileAdapter.fetch(key);
        return Bits.stringSetFromBytes(bytes);
    }

    private int getIntInternal(String key) {
        byte[] bytes = this.fileAdapter.fetch(key);
        return Bits.intFromBytes(bytes);
    }

    private long getLongInternal(String key) {
        byte[] bytes = this.fileAdapter.fetch(key);
        return Bits.longFromBytes(bytes);
    }

    private float getFloatInternal(String key) {
        byte[] bytes = this.fileAdapter.fetch(key);
        return Bits.floatFromBytes(bytes);
    }

    private boolean getBooleanInternal(String key) {
        byte[] bytes = this.fileAdapter.fetch(key);
        return Bits.booleanFromBytes(bytes);
    }

    private <T extends Externalizable> T getObjectInternal(String key) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    private boolean containsInternal(String key) {
        return this.fileAdapter.contains(key);
    }
}

