/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop.task;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.exifinterface.media.ExifInterface;
import com.yalantis.ucrop.callback.BitmapCropCallback;
import com.yalantis.ucrop.model.CropParameters;
import com.yalantis.ucrop.model.ExifInfo;
import com.yalantis.ucrop.model.ImageState;
import com.yalantis.ucrop.util.BitmapLoadUtils;
import com.yalantis.ucrop.util.FileUtils;
import com.yalantis.ucrop.util.ImageHeaderParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;

public class BitmapCropTask
extends AsyncTask<Void, Void, Throwable> {
    private static final String TAG = "BitmapCropTask";
    private final WeakReference<Context> mContext;
    private Bitmap mViewBitmap;
    private final RectF mCropRect;
    private final RectF mCurrentImageRect;
    private float mCurrentScale;
    private float mCurrentAngle;
    private final int mMaxResultImageSizeX;
    private final int mMaxResultImageSizeY;
    private final Bitmap.CompressFormat mCompressFormat;
    private final int mCompressQuality;
    private final String mImageInputPath;
    private final String mImageOutputPath;
    private final ExifInfo mExifInfo;
    private final BitmapCropCallback mCropCallback;
    private int mCroppedImageWidth;
    private int mCroppedImageHeight;
    private int cropOffsetX;
    private int cropOffsetY;

    public BitmapCropTask(@NonNull Context context, @Nullable Bitmap viewBitmap, @NonNull ImageState imageState, @NonNull CropParameters cropParameters, @Nullable BitmapCropCallback cropCallback) {
        this.mContext = new WeakReference<Context>(context);
        this.mViewBitmap = viewBitmap;
        this.mCropRect = imageState.getCropRect();
        this.mCurrentImageRect = imageState.getCurrentImageRect();
        this.mCurrentScale = imageState.getCurrentScale();
        this.mCurrentAngle = imageState.getCurrentAngle();
        this.mMaxResultImageSizeX = cropParameters.getMaxResultImageSizeX();
        this.mMaxResultImageSizeY = cropParameters.getMaxResultImageSizeY();
        this.mCompressFormat = cropParameters.getCompressFormat();
        this.mCompressQuality = cropParameters.getCompressQuality();
        this.mImageInputPath = cropParameters.getImageInputPath();
        this.mImageOutputPath = cropParameters.getImageOutputPath();
        this.mExifInfo = cropParameters.getExifInfo();
        this.mCropCallback = cropCallback;
    }

    @Nullable
    protected Throwable doInBackground(Void ... params) {
        if (this.mViewBitmap == null) {
            return new NullPointerException("ViewBitmap is null");
        }
        if (this.mViewBitmap.isRecycled()) {
            return new NullPointerException("ViewBitmap is recycled");
        }
        if (this.mCurrentImageRect.isEmpty()) {
            return new NullPointerException("CurrentImageRect is empty");
        }
        try {
            this.crop();
            this.mViewBitmap = null;
        }
        catch (Throwable throwable) {
            return throwable;
        }
        return null;
    }

    private boolean crop() throws IOException {
        if (this.mMaxResultImageSizeX > 0 && this.mMaxResultImageSizeY > 0) {
            float cropWidth = this.mCropRect.width() / this.mCurrentScale;
            float cropHeight = this.mCropRect.height() / this.mCurrentScale;
            if (cropWidth > (float)this.mMaxResultImageSizeX || cropHeight > (float)this.mMaxResultImageSizeY) {
                float scaleX = (float)this.mMaxResultImageSizeX / cropWidth;
                float scaleY = (float)this.mMaxResultImageSizeY / cropHeight;
                float resizeScale = Math.min(scaleX, scaleY);
                Bitmap resizedBitmap = Bitmap.createScaledBitmap((Bitmap)this.mViewBitmap, (int)Math.round((float)this.mViewBitmap.getWidth() * resizeScale), (int)Math.round((float)this.mViewBitmap.getHeight() * resizeScale), (boolean)false);
                if (this.mViewBitmap != resizedBitmap) {
                    this.mViewBitmap.recycle();
                }
                this.mViewBitmap = resizedBitmap;
                this.mCurrentScale /= resizeScale;
            }
        }
        if (this.mCurrentAngle != 0.0f) {
            Matrix tempMatrix = new Matrix();
            tempMatrix.setRotate(this.mCurrentAngle, (float)(this.mViewBitmap.getWidth() / 2), (float)(this.mViewBitmap.getHeight() / 2));
            Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)this.mViewBitmap, (int)0, (int)0, (int)this.mViewBitmap.getWidth(), (int)this.mViewBitmap.getHeight(), (Matrix)tempMatrix, (boolean)true);
            if (this.mViewBitmap != rotatedBitmap) {
                this.mViewBitmap.recycle();
            }
            this.mViewBitmap = rotatedBitmap;
        }
        this.cropOffsetX = Math.round((this.mCropRect.left - this.mCurrentImageRect.left) / this.mCurrentScale);
        this.cropOffsetY = Math.round((this.mCropRect.top - this.mCurrentImageRect.top) / this.mCurrentScale);
        this.mCroppedImageWidth = Math.round(this.mCropRect.width() / this.mCurrentScale);
        this.mCroppedImageHeight = Math.round(this.mCropRect.height() / this.mCurrentScale);
        boolean shouldCrop = this.shouldCrop(this.mCroppedImageWidth, this.mCroppedImageHeight);
        Log.i((String)TAG, (String)("Should crop: " + shouldCrop));
        if (shouldCrop) {
            ExifInterface originalExif = new ExifInterface(this.mImageInputPath);
            this.saveImage(Bitmap.createBitmap((Bitmap)this.mViewBitmap, (int)this.cropOffsetX, (int)this.cropOffsetY, (int)this.mCroppedImageWidth, (int)this.mCroppedImageHeight));
            if (this.mCompressFormat.equals((Object)Bitmap.CompressFormat.JPEG)) {
                ImageHeaderParser.copyExif(originalExif, this.mCroppedImageWidth, this.mCroppedImageHeight, this.mImageOutputPath);
            }
            return true;
        }
        FileUtils.copyFile(this.mImageInputPath, this.mImageOutputPath);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImage(@NonNull Bitmap croppedBitmap) throws FileNotFoundException {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        OutputStream outputStream = null;
        try {
            outputStream = context.getContentResolver().openOutputStream(Uri.fromFile((File)new File(this.mImageOutputPath)));
            croppedBitmap.compress(this.mCompressFormat, this.mCompressQuality, outputStream);
            croppedBitmap.recycle();
        }
        catch (Throwable throwable) {
            BitmapLoadUtils.close(outputStream);
            throw throwable;
        }
        BitmapLoadUtils.close(outputStream);
    }

    private boolean shouldCrop(int width, int height) {
        int pixelError = 1;
        return this.mMaxResultImageSizeX > 0 && this.mMaxResultImageSizeY > 0 || Math.abs(this.mCropRect.left - this.mCurrentImageRect.left) > (float)(pixelError += Math.round((float)Math.max(width, height) / 1000.0f)) || Math.abs(this.mCropRect.top - this.mCurrentImageRect.top) > (float)pixelError || Math.abs(this.mCropRect.bottom - this.mCurrentImageRect.bottom) > (float)pixelError || Math.abs(this.mCropRect.right - this.mCurrentImageRect.right) > (float)pixelError || this.mCurrentAngle != 0.0f;
    }

    protected void onPostExecute(@Nullable Throwable t) {
        if (this.mCropCallback != null) {
            if (t == null) {
                Uri uri = Uri.fromFile((File)new File(this.mImageOutputPath));
                this.mCropCallback.onBitmapCropped(uri, this.cropOffsetX, this.cropOffsetY, this.mCroppedImageWidth, this.mCroppedImageHeight);
            } else {
                this.mCropCallback.onCropFailure(t);
            }
        }
    }
}

